/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.curse;

import com.tterrag.registrate.util.entry.RegistryEntry;
import com.xiaoyue.celestial_artifacts.content.core.effect.EffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.ModularCurio;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.AttrAdder;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.core.token.ClientTokenHelper;
import com.xiaoyue.celestial_artifacts.content.core.token.TokenFacet;
import com.xiaoyue.celestial_artifacts.content.loot.EnabledCondition;
import com.xiaoyue.celestial_artifacts.content.loot.HasCurioCondition;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.data.CATagGen;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import com.xiaoyue.celestial_core.content.generic.PlayerFlagData;
import com.xiaoyue.celestial_core.content.loot.PlayerFlagCondition;
import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class CatastropheScroll
extends BaseTickingToken
implements CAAttackToken {
    public static final TokenFacet<CatastropheScroll> TOKEN = new TokenFacet<CatastropheScroll>("catastrophe_scroll", CatastropheScroll::new);

    private static double getChaosBonus() {
        return (Double)CAModConfig.COMMON.curse.chaoticBlessDamageReduction.get();
    }

    private static double getChaosCurseExplosion() {
        return (Double)CAModConfig.COMMON.curse.chaoticExplosionDamage.get();
    }

    private static double getChaosCurse() {
        return (Double)CAModConfig.COMMON.curse.chaoticOtherDamage.get();
    }

    public static int getOriginTrigger() {
        return (Integer)CAModConfig.COMMON.curse.originTriggerDurability.get();
    }

    public static double getOriginCurse() {
        return (Double)CAModConfig.COMMON.curse.originCurseDamage.get();
    }

    public static double getOriginBonus() {
        return (Double)CAModConfig.COMMON.curse.originBlessDamage.get();
    }

    public static double getLifeCurseHealth() {
        return (Double)CAModConfig.COMMON.curse.lifeCurseHealth.get();
    }

    public static double getLifeCurseHeal() {
        return (Double)CAModConfig.COMMON.curse.lifeCurseHeal.get();
    }

    public static double getLifeBonusHealth() {
        return (Double)CAModConfig.COMMON.curse.lifeBlessHealth.get();
    }

    public static double getLifeBonusHeal() {
        return (Double)CAModConfig.COMMON.curse.lifeBlessHeal.get();
    }

    private static double getTruthCurse() {
        return (Double)CAModConfig.COMMON.curse.truthCurseMinDamage.get();
    }

    private static double getTruthBonus() {
        return (Double)CAModConfig.COMMON.curse.truthBlessMaxDamage.get();
    }

    public static double getNihilityCurse() {
        return (Double)CAModConfig.COMMON.curse.nihilityCurseDuration.get();
    }

    private static double getNihilityBonus() {
        return (Double)CAModConfig.COMMON.curse.nihilityBlessReduction.get();
    }

    private static int getNihilityDuration() {
        return (Integer)CAModConfig.COMMON.curse.nihilityBlessDuration.get();
    }

    private static MobEffectInstance getNihilityEffect() {
        return new MobEffectInstance(MobEffects.f_19614_, CatastropheScroll.getNihilityDuration() * 20, 2);
    }

    private static double getEndCurseThreshold() {
        return (Double)CAModConfig.COMMON.curse.endCurseThreshold.get();
    }

    private static double getEndBonus() {
        return (Double)CAModConfig.COMMON.curse.endBlessHeal.get();
    }

    private static int getEndCurseDuration() {
        return (Integer)CAModConfig.COMMON.curse.endCurseDuration.get();
    }

    private static MobEffectInstance getEndEffectA() {
        return new MobEffectInstance(MobEffects.f_19613_, CatastropheScroll.getEndCurseDuration() * 20, 1);
    }

    private static MobEffectInstance getEndEffectB() {
        return new MobEffectInstance(MobEffects.f_19597_, CatastropheScroll.getEndCurseDuration() * 20, 1);
    }

    public static List<Component> addInfo() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Curses curse : Curses.values()) {
            list.add((Component)curse.title.get());
            list.add((Component)TextFacet.wrap(CALang.Curse.TRIGGER_COND.get(new MutableComponent[0]).m_7220_((Component)curse.trigger.get().m_130940_(ChatFormatting.YELLOW))));
            if (curse.curse.size() == 1) {
                list.add((Component)TextFacet.wrap(CALang.Curse.CURSE_EFF.get(new MutableComponent[0]).m_7220_((Component)curse.curse.get(0).get().m_130940_(ChatFormatting.RED))));
            } else {
                list.add((Component)TextFacet.wrap(CALang.Curse.CURSE_EFF.get(new MutableComponent[0])));
                for (Supplier<MutableComponent> e : curse.curse) {
                    list.add((Component)TextFacet.inner(e.get().m_130940_(ChatFormatting.RED)));
                }
            }
            list.add((Component)TextFacet.wrap(CALang.Curse.BLESS_EFF.get(new MutableComponent[0]).m_7220_((Component)curse.bonus.get().m_130940_(ChatFormatting.GREEN))));
        }
        return list;
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        Curses.addText(level, list);
    }

    private List<AttrAdder> attrs(Player player) {
        String name = "catastrophe_scroll";
        return List.of(AttrAdder.of(name, () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_TOTAL, () -> Curses.ORIGIN.cursing(player) ? -CatastropheScroll.getOriginCurse() : (Curses.ORIGIN.blessing(player) ? CatastropheScroll.getOriginBonus() : 0.0)), AttrAdder.of(name, () -> Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_TOTAL, () -> Curses.LIFE.cursing(player) ? -CatastropheScroll.getLifeCurseHealth() : (Curses.LIFE.blessing(player) ? CatastropheScroll.getLifeBonusHealth() : 0.0)), AttrAdder.of(name, () -> ((RegistryEntry)CCAttributes.REPLY_POWER).get(), AttributeModifier.Operation.ADDITION, () -> Curses.LIFE.cursing(player) ? -CatastropheScroll.getLifeCurseHeal() : (Curses.LIFE.blessing(player) ? CatastropheScroll.getLifeBonusHeal() : 0.0)));
    }

    @Override
    protected void removeImpl(Player player) {
        this.attrs(player).forEach(e -> e.removeImpl(player));
    }

    @Override
    protected void tickImpl(Player player) {
        this.attrs(player).forEach(e -> e.tickImpl(player));
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
        if (player.f_19797_ % 20 == 0 && Curses.DESIRE.cursing(player)) {
            List entities = player.m_9236_().m_45976_(LivingEntity.class, EntityUtils.getAABB((LivingEntity)player, (float)8.0f, (float)2.0f));
            for (LivingEntity e2 : entities) {
                if (e2.m_6095_().m_204039_(CATagGen.DESIRE_BLACKLIST)) continue;
                if (e2.m_21215_() < e2.f_19797_ - 20) {
                    e2.m_21335_((Entity)player);
                }
                if (e2.m_21213_() >= e2.f_19797_ - 20) continue;
                e2.m_6703_((LivingEntity)player);
            }
        }
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        if (Curses.END.blessing(player)) {
            player.m_5634_((player.m_21233_() - player.m_21223_()) * (float)CatastropheScroll.getEndBonus());
        }
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        float factor = 1.0f;
        if (Curses.CHAOS.blessing(player)) {
            float max = (float)CatastropheScroll.getChaosBonus();
            factor *= 1.0f - max * (1.0f - player.m_21223_() / player.m_21233_());
        }
        if (Curses.CHAOS.cursing(player)) {
            factor = CAAttackToken.getSource(cache).m_276093_(DamageTypes.f_268565_) ? (factor *= (float)(1.0 + CatastropheScroll.getChaosCurseExplosion())) : (factor *= (float)(1.0 + CatastropheScroll.getChaosCurse()));
        }
        if (Curses.NIHILITY.blessing(player)) {
            if (CAAttackToken.getSource(cache).m_276093_(DamageTypes.f_268724_)) {
                factor *= 1.0f - (float)CatastropheScroll.getNihilityBonus();
            }
            if (cache.getAttacker() != null) {
                cache.getAttacker().m_7292_(CatastropheScroll.getNihilityEffect());
            }
        }
        cache.addDealtModifier(DamageModifier.multTotal((float)factor));
        if (cache.getAttacker() != null) {
            float hp;
            if (Curses.TRUTH.blessing(player)) {
                hp = player.m_21233_() * (float)CatastropheScroll.getTruthBonus();
                cache.addDealtModifier(DamageModifier.nonlinearPre((int)345, e -> Math.min(e, hp)));
            }
            if (Curses.TRUTH.cursing(player)) {
                hp = player.m_21233_() * (float)CatastropheScroll.getTruthCurse();
                cache.addDealtModifier(DamageModifier.nonlinearPre((int)345, e -> e <= 0.0f ? 0.0f : Math.max(e, hp)));
            }
        }
    }

    @Override
    public void onPlayerDamagedFinal(Player player, AttackCache cache) {
        if (Curses.END.cursing(player) && (double)cache.getDamageDealt() >= (double)player.m_21233_() * CatastropheScroll.getEndCurseThreshold()) {
            player.m_7292_(CatastropheScroll.getEndEffectA());
            player.m_7292_(CatastropheScroll.getEndEffectB());
        }
    }

    public static enum Curses {
        CHAOS((Supplier<? extends Item>)CAItems.CHAOTIC_ETCHING, () -> CALang.Curse.CHAOS_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.CHAOS_TRIGGER.get(new MutableComponent[0]), List.of(() -> CALang.Curse.CHAOS_CURSE_0.get(TextFacet.perc(CatastropheScroll.getChaosCurseExplosion())), () -> CALang.Curse.CHAOS_CURSE_1.get(TextFacet.perc(CatastropheScroll.getChaosCurse()))), () -> CALang.Curse.CHAOS_BONUS.get(TextFacet.perc(0.01), TextFacet.percSmall(CatastropheScroll.getChaosBonus() * 0.01))),
        ORIGIN((Supplier<? extends Item>)CAItems.ORIGIN_ETCHING, () -> CALang.Curse.ORIGIN_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.ORIGIN_TRIGGER.get(TextFacet.num(CatastropheScroll.getOriginTrigger())), () -> CALang.Curse.ORIGIN_CURSE.get(TextFacet.perc(CatastropheScroll.getOriginCurse())), () -> CALang.Curse.ORIGIN_BONUS.get(TextFacet.perc(CatastropheScroll.getOriginBonus()))),
        LIFE((Supplier<? extends Item>)CAItems.LIFE_ETCHING, () -> CALang.Curse.LIFE_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.LIFE_TRIGGER.get(new MutableComponent[0]), () -> CALang.Curse.LIFE_CURSE.get(TextFacet.perc(CatastropheScroll.getLifeCurseHealth()), TextFacet.perc(CatastropheScroll.getLifeCurseHeal())), () -> CALang.Curse.LIFE_BONUS.get(TextFacet.perc(CatastropheScroll.getLifeBonusHealth()), TextFacet.perc(CatastropheScroll.getLifeBonusHeal()))),
        TRUTH((Supplier<? extends Item>)CAItems.TRUTH_ETCHING, () -> CALang.Curse.TRUTH_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.TRUTH_TRIGGER.get(new MutableComponent[0]), () -> CALang.Curse.TRUTH_CURSE.get(TextFacet.perc(CatastropheScroll.getTruthCurse())), () -> CALang.Curse.TRUTH_BONUS.get(TextFacet.perc(CatastropheScroll.getTruthBonus()))),
        DESIRE((Supplier<? extends Item>)CAItems.DESIRE_ETCHING, () -> CALang.Curse.DESIRE_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.DESIRE_TRIGGER.get(new MutableComponent[0]), () -> CALang.Curse.DESIRE_CURSE.get(new MutableComponent[0]), () -> CALang.Curse.DESIRE_BONUS.get(TextFacet.num(1))),
        NIHILITY((Supplier<? extends Item>)CAItems.NIHILITY_ETCHING, () -> CALang.Curse.NIHILITY_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.NIHILITY_TRIGGER.get(new MutableComponent[0]), () -> CALang.Curse.NIHILITY_CURSE.get(TextFacet.perc(CatastropheScroll.getNihilityCurse())), () -> CALang.Curse.NIHILITY_BONUS.get(TextFacet.perc(CatastropheScroll.getNihilityBonus()), EffectFacet.getDesc(CatastropheScroll.getNihilityEffect()))),
        END((Supplier<? extends Item>)CAItems.END_ETCHING, () -> CALang.Curse.END_TITLE.get(new MutableComponent[0]), () -> CALang.Curse.END_TRIGGER.get(new MutableComponent[0]), () -> CALang.Curse.END_CURSE.get(TextFacet.perc(CatastropheScroll.getEndCurseThreshold()), EffectFacet.getDesc(CatastropheScroll.getEndEffectA()), EffectFacet.getDesc(CatastropheScroll.getEndEffectB())), () -> CALang.Curse.END_BONUS.get(TextFacet.perc(CatastropheScroll.getEndBonus())));

        public final Supplier<MutableComponent> title;
        public final Supplier<MutableComponent> trigger;
        public final Supplier<MutableComponent> bonus;
        private final Supplier<? extends Item> etching;
        private final List<Supplier<MutableComponent>> curse;

        private Curses(Supplier<? extends Item> etching, Supplier<MutableComponent> title, Supplier<MutableComponent> trigger, List<Supplier<MutableComponent>> curse, Supplier<MutableComponent> bonus) {
            this.etching = etching;
            this.title = title;
            this.trigger = trigger;
            this.curse = curse;
            this.bonus = bonus;
        }

        private Curses(Supplier<? extends Item> etching, Supplier<MutableComponent> title, Supplier<MutableComponent> trigger, Supplier<MutableComponent> curse, Supplier<MutableComponent> bonus) {
            this(etching, title, trigger, List.of(curse), bonus);
        }

        private static void wrap(List<Component> list, MutableComponent comp) {
            list.add((Component)TextFacet.wrap(comp.m_130940_(ChatFormatting.GRAY)));
        }

        private static void inner(List<Component> list, MutableComponent comp) {
            list.add((Component)TextFacet.inner(comp.m_130940_(ChatFormatting.GRAY)));
        }

        private static void addText(@Nullable Level level, List<Component> list) {
            if (((Boolean)CAModConfig.COMMON.misc.catastropheScrollPreventUnequip.get()).booleanValue()) {
                Curses.wrap(list, CALang.Curse.SCROLL_0.get(new MutableComponent[0]));
            }
            Curses.wrap(list, CALang.Curse.SCROLL_1.get(new MutableComponent[0]));
            Curses.wrap(list, CALang.Curse.SCROLL_2.get(new MutableComponent[0]));
            list.add((Component)Component.m_237119_());
            for (Curses curse : Curses.values()) {
                boolean disabled = !ClientTokenHelper.flag(level, curse.name());
                boolean bonus = ClientTokenHelper.hasCurio(level, curse.etching.get());
                list.add((Component)TextFacet.wrap(curse.title.get().m_130940_(disabled ? ChatFormatting.GRAY : (bonus ? ChatFormatting.YELLOW : ChatFormatting.RED))));
                if (disabled) {
                    Curses.inner(list, curse.trigger.get());
                    continue;
                }
                if (bonus) {
                    Curses.inner(list, curse.bonus.get());
                    continue;
                }
                for (Supplier<MutableComponent> e : curse.curse) {
                    Curses.inner(list, e.get());
                }
            }
        }

        public void trigger(Player player) {
            PlayerFlagData flags = (PlayerFlagData)PlayerFlagData.HOLDER.get(player);
            if (!flags.hasFlag(this.name())) {
                flags.addFlag(this.name());
                if (CurioUtils.isCsOn(player) && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.m_240418_((Component)CALang.Curse.TRIGGER.get(this.title.get()).m_130940_(ChatFormatting.RED), true);
                }
            }
        }

        public boolean cursing(Player player) {
            return ((PlayerFlagData)PlayerFlagData.HOLDER.get(player)).hasFlag(this.name()) && CurioUtils.isCsOn(player) && !CurioUtils.hasCurio(player, this.etching.get());
        }

        public boolean blessing(Player player) {
            return ((PlayerFlagData)PlayerFlagData.HOLDER.get(player)).hasFlag(this.name()) && CurioUtils.isCsOn(player) && CurioUtils.hasCurio(player, this.etching.get());
        }

        public LootItemCondition asCondition() {
            return AllOfCondition.m_285871_((LootItemCondition.Builder[])new LootItemCondition.Builder[]{new EnabledCondition((ModularCurio)this.etching.get()), new HasCurioCondition((Item)CAItems.CATASTROPHE_SCROLL.get()), () -> new PlayerFlagCondition(this.name()), new HasCurioCondition(this.etching.get()).m_81807_()}).m_6409_();
        }
    }
}

