/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.set;

import com.xiaoyue.celestial_artifacts.content.core.effect.EffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import com.xiaoyue.celestial_core.register.CCEffects;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class SpiritSet
extends BaseTickingToken
implements CAAttackToken {
    private static int getEffectThreshold() {
        return (Integer)CAModConfig.COMMON.set.spiritPullDuration.get();
    }

    private static double getBackShootDamage() {
        return (Double)CAModConfig.COMMON.set.spiritBackShootBonus.get();
    }

    private static double getInflictChance() {
        return (Double)CAModConfig.COMMON.set.spiritInflictChance.get();
    }

    private static double getProtect() {
        return (Double)CAModConfig.COMMON.set.spiritProtect.get();
    }

    private static CALang.DamageTypes type() {
        return CALang.DamageTypes.PROJECTILE;
    }

    private static MobEffect getTrigger() {
        return MobEffects.f_19596_;
    }

    private static MobEffectInstance getPullEff() {
        return new MobEffectInstance((MobEffect)CCEffects.ARROW_DAMAGE.get(), 40, 0, true, true);
    }

    private static MobEffectInstance getInflictEff() {
        return new MobEffectInstance(MobEffects.f_19597_, (Integer)CAModConfig.COMMON.set.spiritEffectDuration.get() * 20, ((Integer)CAModConfig.COMMON.set.spiritEffectAmplifier.get()).intValue());
    }

    @Override
    protected void removeImpl(Player player) {
    }

    @Override
    protected void tickImpl(Player player) {
        if (player.m_6117_() && CurioUtils.isRangeUseAnim(player.m_21211_().m_41780_()) && player.m_21252_() >= SpiritSet.getEffectThreshold() * 20) {
            EffectUtil.refreshEffect((LivingEntity)player, (MobEffectInstance)SpiritSet.getPullEff(), (EffectUtil.AddReason)EffectUtil.AddReason.SELF, (Entity)player);
        }
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        if (!CAAttackToken.isArrow(cache)) {
            return;
        }
        if (EntityUtils.isLookingBehindTarget((LivingEntity)cache.getAttackTarget(), (Vec3)player.m_146892_())) {
            float factor = 1.0f + (float)SpiritSet.getBackShootDamage();
            cache.addHurtModifier(DamageModifier.multTotal((float)factor));
        }
        if (player.m_21023_(SpiritSet.getTrigger()) && CAAttackToken.chance((LivingEntity)player, SpiritSet.getInflictChance())) {
            cache.getAttackTarget().m_7292_(SpiritSet.getInflictEff());
        }
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        if (player.m_21023_(SpiritSet.getTrigger()) && CAAttackToken.isArrow(cache)) {
            float factor = 1.0f - (float)SpiritSet.getProtect();
            cache.addDealtModifier(DamageModifier.multTotal((float)factor));
        }
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.set(level, CAItems.spiritSet()));
        list.add((Component)TextFacet.wrap(CALang.Sets.SPIRIT_0.get(TextFacet.num(SpiritSet.getEffectThreshold()), EffectFacet.getDesc(SpiritSet.getPullEff(), false))).m_130940_(ChatFormatting.GRAY));
        list.add((Component)TextFacet.wrap(CALang.Sets.SPIRIT_1.get(SpiritSet.type().get(new MutableComponent[0]), TextFacet.perc(SpiritSet.getBackShootDamage())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.wrap(CALang.Sets.SPIRIT_2.get(TextFacet.eff(SpiritSet.getTrigger())).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Sets.SPIRIT_3.get(TextFacet.perc(SpiritSet.getInflictChance()), EffectFacet.getDesc(SpiritSet.getInflictEff(), true)).m_130940_(ChatFormatting.GRAY)));
        list.add((Component)TextFacet.inner(CALang.Modular.PROTECT_TYPE.get(SpiritSet.type().get(new MutableComponent[0]), TextFacet.perc(SpiritSet.getProtect())).m_130940_(ChatFormatting.GRAY)));
    }
}

