/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.loot;

import com.xiaoyue.celestial_artifacts.register.CALootModifier;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import dev.xkmc.l2serial.serialization.SerialClass;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@SerialClass
public class FishingCondition
implements LootItemCondition,
LootItemCondition.Builder {
    @SerialClass.SerialField
    public boolean open;
    @SerialClass.SerialField
    @Nullable
    public Item item;
    @SerialClass.SerialField
    @Nullable
    public TagKey<Biome> biomes;

    @Deprecated
    public FishingCondition() {
    }

    public FishingCondition(boolean open) {
        this.open = open;
    }

    public FishingCondition(boolean open, Item item, TagKey<Biome> biomes) {
        this.open = open;
        this.item = item;
        this.biomes = biomes;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)CALootModifier.FISHING.get();
    }

    public boolean test(LootContext ctx) {
        if (!ctx.m_78936_(LootContextParams.f_81455_)) {
            return false;
        }
        Object object = ctx.m_165124_(LootContextParams.f_81455_);
        if (object instanceof FishingHook) {
            FishingHook hook = (FishingHook)object;
            boolean isOpen = hook.m_37166_() == this.open;
            Player player = hook.m_37168_();
            if (this.item == null || player == null || this.biomes == null || player.m_36335_().m_41519_(this.item)) {
                return isOpen;
            }
            return CurioUtils.hasCurio(player, this.item) && player.m_9236_().m_204166_(player.m_20097_()).m_203656_(this.biomes) && isOpen;
        }
        return false;
    }

    public LootItemCondition m_6409_() {
        return this;
    }
}

