/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.loot;

import com.xiaoyue.celestial_artifacts.register.CALootModifier;
import com.xiaoyue.celestial_core.content.loot.IntConfigValue;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.function.BiFunction;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

@SerialClass
public class PlayerStatCondition
implements LootItemCondition {
    @SerialClass.SerialField
    public Type type;
    @SerialClass.SerialField
    public String count;

    @Deprecated
    public PlayerStatCondition() {
    }

    public PlayerStatCondition(Type type, IntConfigValue count) {
        this.type = type;
        this.count = count.toData();
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)CALootModifier.PLAYER_STAT.get();
    }

    public boolean test(LootContext ctx) {
        if (!ctx.m_78936_(LootContextParams.f_81456_)) {
            return false;
        }
        Player player = (Player)ctx.m_165124_(LootContextParams.f_81456_);
        return this.type.get(player, ctx) >= IntConfigValue.of((String)this.count).get();
    }

    public static enum Type {
        LOOT((player, ctx) -> ctx.getLootingModifier()),
        REPUTATION((player, ctx) -> {
            Integer n;
            Object patt1559$temp;
            if (ctx.m_78936_(LootContextParams.f_81455_) && (patt1559$temp = ctx.m_165124_(LootContextParams.f_81455_)) instanceof Villager) {
                Villager vil = (Villager)patt1559$temp;
                n = vil.m_35532_(player);
            } else {
                n = 0;
            }
            return n;
        });

        private final BiFunction<Player, LootContext, Integer> func;

        private Type(BiFunction<Player, LootContext, Integer> func) {
            this.func = func;
        }

        public int get(Player player, LootContext ctx) {
            return this.func.apply(player, ctx);
        }
    }
}

