/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.data;

import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.xiaoyue.celestial_artifacts.CelestialArtifacts;
import com.xiaoyue.celestial_artifacts.content.core.modular.ModularCurio;
import com.xiaoyue.celestial_artifacts.content.loot.EnabledCondition;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import dev.xkmc.l2library.util.data.LootTableTemplate;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public enum CALootTableGen implements CALang.Info
{
    VILLAGE_PLAINS_HOUSE("Plains Village House", BuiltInLootTables.f_78755_, 7, new Supplier[]{CAItems.CROSS_NECKLACE, CAItems.RED_HEART_NECKLACE}),
    ABANDONED_MINESHAFT("Abandoned Mineshaft", BuiltInLootTables.f_78759_, 5, new Supplier[]{CAItems.FANG_NECKLACE}),
    END_CITY_TREASURE("End City", BuiltInLootTables.f_78741_, 5, new Supplier[]{CAItems.TRAVELER_SCROLL}),
    ANCIENT_CITY("Ancient City", BuiltInLootTables.f_230876_, 9, new Supplier[]{CAItems.UNOWNED_PENDANT, CAItems.DEMON_HEART}),
    BASTION_TREASURE("Bastion Treasure Room", BuiltInLootTables.f_78697_, 3, new Supplier[]{CAItems.HEART_OF_REVENGE}),
    DESERT_PYRAMID("Desert Pyramid", BuiltInLootTables.f_78764_, 5, new Supplier[]{CAItems.SANDS_TALISMAN}),
    JUNGLE_TEMPLE("Jungle Temple", BuiltInLootTables.f_78686_, 12, new Supplier[]{CAItems.SPIRIT_ARROW_BAG, CAItems.SPIRIT_NECKLACE, CAItems.SPIRIT_BRACELET, CAItems.SPIRIT_CROWN}),
    NETHER_BRIDGE("Nether Fortress Bridge", BuiltInLootTables.f_78760_, 5, new Supplier[]{CAItems.RED_RUBY_BRACELET}),
    UNDERWATER_RUIN_BIG("Big Underwater Ruin", BuiltInLootTables.f_78691_, 7, new Supplier[]{CAItems.LEECH_SCABBARD, CAItems.THUNDER_RING}),
    FISHING_TREASURE("Can be fished at y>300", BuiltInLootTables.f_78720_, 5, new Supplier[]{CAItems.MAGIC_HORSESHOE});

    public final List<Supplier<ModularCurio>> item;
    public final ResourceLocation target;
    public final int odds;
    private final CALang.Entry entry;

    @SafeVarargs
    private CALootTableGen(String def, ResourceLocation target, int odds, Supplier<ModularCurio> ... item) {
        this.entry = new CALang.Entry(this.name().toLowerCase(Locale.ROOT), def, 0);
        this.item = List.of(item);
        this.target = target;
        this.odds = odds - item.length;
    }

    public static void onLootGen(RegistrateLootTableProvider pvd) {
        pvd.addLootAction(LootContextParamSets.f_81410_, cons -> {
            for (CALootTableGen e : CALootTableGen.values()) {
                LootPool.Builder pool = LootPool.m_79043_();
                for (Supplier<ModularCurio> item : e.item) {
                    LootPoolSingletonContainer.Builder entry = LootTableTemplate.getItem((Item)item.get(), (int)1).m_79707_(1);
                    entry.m_79080_((LootItemCondition.Builder)new EnabledCondition(item.get()));
                    if (item.get() == CAItems.MAGIC_HORSESHOE.get()) {
                        entry.m_79080_(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_153974_(MinMaxBounds.Doubles.m_154804_((double)300.0))));
                    }
                    pool.m_79076_((LootPoolEntryContainer.Builder)entry);
                }
                pool.m_79076_((LootPoolEntryContainer.Builder)LootTableTemplate.getItem((Item)Items.f_41852_, (int)0).m_79707_(e.odds));
                cons.accept(e.id(), LootTable.m_79147_().m_79161_(pool));
            }
        });
    }

    @Override
    public CALang.Entry entry() {
        return this.entry;
    }

    public ResourceLocation id() {
        return CelestialArtifacts.loc("chests/" + this.name().toLowerCase(Locale.ROOT));
    }
}

