/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.mode.ExchangerModeHorizontalCol;
import jackyy.exchangers.handler.mode.ExchangerModePlane;
import jackyy.exchangers.handler.mode.ExchangerModeVerticalCol;
import jackyy.exchangers.helper.ChatHelper;
import jackyy.exchangers.helper.StringHelper;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ExchangerHandler {
    public static final String[] modeSwitchList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("blockstate", (NBTBase)new NBTTagCompound());
            NBTUtil.func_190009_a((NBTTagCompound)compound.func_74775_l("blockstate"), (IBlockState)Blocks.field_150350_a.func_176223_P());
            compound.func_74768_a("exmode", 0);
            compound.func_74768_a("range", 0);
            compound.func_74757_a("forceDropItems", false);
            stack.func_77982_d(compound);
        } else if (!stack.func_77978_p().func_74764_b("blockstate")) {
            stack.func_77978_p().func_74782_a("blockstate", (NBTBase)new NBTTagCompound());
            NBTUtil.func_190009_a((NBTTagCompound)stack.func_77978_p().func_74775_l("blockstate"), (IBlockState)Blocks.field_150350_a.func_176223_P());
        } else if (!stack.func_77978_p().func_74764_b("exmode")) {
            stack.func_77978_p().func_74768_a("exmode", 0);
        } else if (!stack.func_77978_p().func_74764_b("range")) {
            stack.func_77978_p().func_74768_a("range", 0);
        } else if (!stack.func_77978_p().func_74764_b("forceDropItems")) {
            stack.func_77978_p().func_74757_a("forceDropItems", false);
        }
    }

    private static int getExPerBlockUse(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getPerBlockUse();
    }

    private static int getPerBlockEnergy(ItemStack stack) {
        int level;
        if (ModConfig.misc.unbreakingPoweredExchangers && new Random().nextInt(2 + (level = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10))) >= 2) {
            return 0;
        }
        return ExchangerHandler.getExPerBlockUse(stack);
    }

    private static int getExHarvestLevel(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getHarvestLevel();
    }

    private static int getExRange(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).getMaxRange();
    }

    private static boolean getExIsCreative(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isCreative();
    }

    private static boolean getExIsPowered(ItemStack stack) {
        return ((ItemExchangerBase)stack.func_77973_b()).isPowered();
    }

    public static void switchRange(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int rangeSwitch = stack.func_77978_p().func_74762_e("range");
        rangeSwitch = player.func_70093_af() ? --rangeSwitch : ++rangeSwitch;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem != null) {
            if (rangeSwitch > ExchangerHandler.getExRange(stack)) {
                rangeSwitch = 0;
            } else if (rangeSwitch < 0) {
                rangeSwitch = ExchangerHandler.getExRange(stack);
            }
        }
        stack.func_77978_p().func_74768_a("range", rangeSwitch);
    }

    public static void switchMode(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        int mode = stack.func_77978_p().func_74762_e("exmode");
        mode = player.func_70093_af() ? --mode : ++mode;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem != null) {
            if (mode > 2) {
                mode = 0;
            } else if (mode < 0) {
                mode = 2;
            }
        }
        stack.func_77978_p().func_74768_a("exmode", mode);
        switch (mode) {
            case 0: {
                ChatHelper.msgPlayerRaw(player, StringHelper.localize("msg.mode", new Object[0]) + " " + TextFormatting.GREEN + TextFormatting.ITALIC + StringHelper.localize("mode.plane", new Object[0]));
                break;
            }
            case 1: {
                ChatHelper.msgPlayerRaw(player, StringHelper.localize("msg.mode", new Object[0]) + " " + TextFormatting.GREEN + TextFormatting.ITALIC + StringHelper.localize("mode.horizontal", new Object[0]));
                break;
            }
            case 2: {
                ChatHelper.msgPlayerRaw(player, StringHelper.localize("msg.mode", new Object[0]) + " " + TextFormatting.GREEN + TextFormatting.ITALIC + StringHelper.localize("mode.vertical", new Object[0]));
            }
        }
    }

    public static void toggleForceDropItems(EntityPlayer player, ItemStack stack) {
        ExchangerHandler.setDefaultTagCompound(stack);
        boolean toggle = stack.func_77978_p().func_74767_n("forceDropItems");
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem != null) {
            toggle = !toggle;
        }
        stack.func_77978_p().func_74757_a("forceDropItems", toggle);
        ChatHelper.msgPlayer(player, toggle ? "msg.force_drop_items.on" : "msg.force_drop_items.off");
    }

    public static boolean isWhitelisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksWhitelist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(World world, BlockPos pos) {
        for (String block : ModConfig.misc.blocksBlacklist) {
            if (!world.func_180495_p(pos).func_177230_c().getRegistryName().equals((Object)new ResourceLocation(block))) continue;
            return true;
        }
        return false;
    }

    public static void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("blockstate"));
        Block block = state.func_177230_c();
        IBlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        float blockHardness = oldblock.func_176195_g(oldState, world, pos);
        if (block == Blocks.field_150350_a) {
            return;
        }
        if (block == oldblock && state == oldState) {
            return;
        }
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer(player, "error.invalid_block.unbreakable");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExIsPowered(stack) && stack.func_77978_p().func_74762_e("Energy") < ExchangerHandler.getPerBlockEnergy(stack)) {
            ChatHelper.msgPlayer(player, "error.out_of_power");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && ExchangerHandler.getExHarvestLevel(stack) < oldblock.getHarvestLevel(oldState)) {
            ChatHelper.msgPlayer(player, "error.low_harvest_level");
            return;
        }
        Set<BlockPos> coordinates = ExchangerHandler.findSuitableBlocks(stack, world, player, side, pos, oldState);
        boolean notEnough = false;
        world.captureBlockSnapshots = false;
        for (BlockPos coordinate : coordinates) {
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)coordinate, (int)3), Blocks.field_150350_a.func_176223_P(), player, player.func_184600_cs());
            world.func_180501_a(coordinate, state, 3);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (ExchangerHandler.consumeItemInInventory(Item.func_150898_a((Block)block), state.func_177230_c().func_185473_a(world, pos, state).func_77960_j(), player.field_71071_by, player)) {
                    if (!player.field_71075_bZ.field_75098_d && !ExchangerHandler.getExIsCreative(stack)) {
                        if (ModConfig.misc.doExchangersSilkTouch || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                            ItemStack oldblockItem = oldblock.func_185473_a(world, pos, oldState);
                            ExchangerHandler.giveItem(world, player, oldblockItem);
                        } else {
                            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                            List oldblockItems = oldblock.getDrops((IBlockAccess)world, pos, oldState, fortuneLevel);
                            for (ItemStack oldblockItem : oldblockItems) {
                                ExchangerHandler.giveItem(world, player, oldblockItem);
                            }
                        }
                        if (!ExchangerHandler.getExIsPowered(stack)) {
                            stack.func_77972_a(1, (EntityLivingBase)player);
                        } else if (stack.func_77978_p().func_74762_e("Energy") >= ExchangerHandler.getPerBlockEnergy(stack)) {
                            stack.func_77978_p().func_74768_a("Energy", stack.func_77978_p().func_74762_e("Energy") - ExchangerHandler.getPerBlockEnergy(stack));
                        }
                        player.field_71070_bA.func_75142_b();
                    }
                    world.func_184148_a(null, (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    continue;
                }
                world.restoringBlockSnapshots = true;
                event.getBlockSnapshot().restore(true);
                world.restoringBlockSnapshots = false;
                notEnough = true;
                continue;
            }
            world.restoringBlockSnapshots = true;
            event.getBlockSnapshot().restore(true);
            world.restoringBlockSnapshots = false;
            ChatHelper.msgPlayer(player, "error.event_cancelled");
        }
        if (notEnough) {
            ChatHelper.msgPlayer(player, "error.out_of_block");
        }
        world.captureBlockSnapshots = true;
    }

    public static void selectBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        ExchangerHandler.setDefaultTagCompound(stack);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        NBTTagCompound tagCompound = ExchangerHandler.getTagCompound(stack);
        float blockHardness = block.func_176195_g(state, world, pos);
        if (world.func_175625_s(pos) != null && !ExchangerHandler.isWhitelisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.invalid_block.te");
            return;
        }
        if (ExchangerHandler.isBlacklisted(world, pos)) {
            ChatHelper.msgPlayer(player, "error.blacklisted");
            return;
        }
        if (!ExchangerHandler.getExIsCreative(stack) && blockHardness < -0.1f) {
            ChatHelper.msgPlayer(player, "error.invalid_block.unbreakable");
            return;
        }
        NBTUtil.func_190009_a((NBTTagCompound)tagCompound.func_74775_l("blockstate"), (IBlockState)state);
    }

    public static Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EntityPlayer player, EnumFacing sideHit, BlockPos pos, IBlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int range = stack.func_77978_p().func_74762_e("range");
        int mode = stack.func_77978_p().func_74762_e("exmode");
        switch (mode) {
            case 0: {
                ExchangerModePlane.invoke(coordinates, range, world, sideHit, pos, centerState);
                break;
            }
            case 1: {
                ExchangerModeHorizontalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
                break;
            }
            case 2: {
                ExchangerModeVerticalCol.invoke(coordinates, range, world, player, sideHit, pos, centerState);
            }
        }
        return coordinates;
    }

    public static void checkAndAddBlock(World world, BlockPos pos, IBlockState centerState, Set<BlockPos> coordinates) {
        IBlockState state = world.func_180495_p(pos);
        if (state == centerState) {
            coordinates.add(pos);
        }
    }

    private static boolean consumeItemInInventory(Item item, int meta, InventoryPlayer playerInv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || ExchangerHandler.getExIsCreative(player.func_184614_ca())) {
            return true;
        }
        int i = ExchangerHandler.findItem(item, meta, (IInventory)playerInv);
        if (i < 0) {
            IItemHandler inv = ExchangerHandler.findItemHolder((IInventory)playerInv);
            if (inv == null) {
                return false;
            }
            i = ExchangerHandler.findItemInContainer(item, meta, inv);
            if (i < 0) {
                return false;
            }
            ItemStack extracted = inv.extractItem(i, 1, false);
            return extracted != null;
        }
        playerInv.func_70298_a(i, 1);
        return true;
    }

    private static int findItem(Item item, int meta, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static int findItemInContainer(Item item, int meta, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static IItemHandler findItemHolder(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            return (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return null;
    }

    private static void giveItem(World world, EntityPlayer player, ItemStack oldStack) {
        EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, oldStack);
        if (player.func_184614_ca().func_77978_p().func_74767_n("forceDropItems")) {
            world.func_72838_d((Entity)entityItem);
        } else if (!player.field_71071_by.func_70441_a(oldStack)) {
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static String getBlockName(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        try {
            String name = stack.func_82833_r();
            return name;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "Unable to fetch block name.";
        }
    }
}

