/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import jackyy.exchangers.Exchangers;
import jackyy.exchangers.client.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.helper.StringHelper;
import jackyy.exchangers.registry.ModConfig;
import jackyy.exchangers.util.IExchanger;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemExchangerBase
extends Item
implements IExchanger {
    public ItemExchangerBase() {
        this.func_77625_d(1);
        this.func_77637_a(Exchangers.TAB);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ExchangerHandler.selectBlock(stack, player, world, pos);
            } else {
                ExchangerHandler.placeBlock(stack, player, world, pos, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean bool) {
        super.func_77624_a(stack, player, tooltip, bool);
        ExchangerHandler.setDefaultTagCompound(stack);
        NBTTagCompound compound = stack.func_77978_p();
        IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("blockstate"));
        Block block = state.func_177230_c();
        int mode = stack.func_77978_p().func_74762_e("exmode");
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getShiftText());
        }
        if (StringHelper.isShiftKeyDown()) {
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.selected_block", new Object[0]) + " " + (block == Blocks.field_150350_a ? TextFormatting.RED + StringHelper.localize("tooltip.selected_block.none", new Object[0]) : TextFormatting.GREEN + ExchangerHandler.getBlockName(block, state.func_177230_c().func_176201_c(state))));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.current_range", new Object[0]) + " " + TextFormatting.GREEN + ExchangerHandler.modeSwitchList[compound.func_74762_e("range")]);
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.max_range", new Object[0]) + " " + TextFormatting.GREEN + ExchangerHandler.modeSwitchList[this.getMaxRange()]);
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.max_harvest_level", new Object[0]) + " " + TextFormatting.GREEN + StringHelper.formatHarvestLevel(this.getHarvestLevel()));
            switch (mode) {
                case 0: {
                    tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.current_mode", new Object[0]) + " " + TextFormatting.GREEN + StringHelper.localize("mode.plane", new Object[0]));
                    break;
                }
                case 1: {
                    tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.current_mode", new Object[0]) + " " + TextFormatting.GREEN + StringHelper.localize("mode.horizontal", new Object[0]));
                    break;
                }
                case 2: {
                    tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.current_mode", new Object[0]) + " " + TextFormatting.GREEN + StringHelper.localize("mode.vertical", new Object[0]));
                }
            }
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.silk_touch", ModConfig.misc.doExchangersSilkTouch ? TextFormatting.GREEN + StringHelper.localize("tooltip.state.enabled", new Object[0]) + TextFormatting.WHITE : TextFormatting.RED + StringHelper.localize("tooltip.state.disabled", new Object[0]) + TextFormatting.WHITE));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.force_drop_items", compound.func_74767_n("forceDropItems") ? TextFormatting.GREEN + StringHelper.localize("tooltip.state.enabled", new Object[0]) + TextFormatting.WHITE : TextFormatting.RED + StringHelper.localize("tooltip.state.disabled", new Object[0]) + TextFormatting.WHITE));
        }
        if (!StringHelper.isCtrlKeyDown()) {
            tooltip.add(StringHelper.getCtrlText());
        }
        if (StringHelper.isCtrlKeyDown()) {
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.extra1", new Object[0]));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.extra2", new Object[0]));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.extra3", TextFormatting.GREEN + Keys.RANGE_SWITCH_KEY.getDisplayName() + TextFormatting.WHITE));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.extra4", TextFormatting.GREEN + Keys.MODE_SWITCH_KEY.getDisplayName() + TextFormatting.WHITE));
            tooltip.add(TextFormatting.WHITE + StringHelper.localize("tooltip.extra5", TextFormatting.GREEN + Keys.FORCE_DROP_ITEMS_KEY.getDisplayName() + TextFormatting.WHITE));
        }
        if (StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getTierText(this.getTier()));
            if (!this.isPowered()) {
                tooltip.add(StringHelper.formatNumber(stack.func_77958_k() - stack.func_77952_i()) + " / " + StringHelper.formatNumber(stack.func_77958_k()) + " " + StringHelper.localize("tooltip.durability", new Object[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.checkLoaded()) {
            list.add(new ItemStack((Item)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 20;
    }
}

