/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.item;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.IEnchantableItem;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.helper.EnergyHelper;
import jackyy.exchangers.helper.NBTHelper;
import jackyy.exchangers.helper.StringHelper;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.registry.ModConfig;
import jackyy.exchangers.util.EnergyContainerItemWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="cofh.core.item.IEnchantableItem", modid="cofhcore")
public class ItemExchangerBasePowered
extends ItemExchangerBase
implements IEnergyContainerItem,
IEnchantableItem {
    @GameRegistry.ObjectHolder(value="cofhcore:holding")
    public static final Enchantment holding = null;

    public ItemExchangerBasePowered() {
        this.func_77656_e(1);
    }

    @Override
    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.receiveEnergy(container, energy, this.getMaxEnergyStored(container), simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.extractEnergy(container, energy, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        if (ModConfig.misc.holdingEnchantment && Loader.isModLoaded((String)"cofhcore")) {
            int enchant = EnchantmentHelper.func_77506_a((Enchantment)holding, (ItemStack)container);
            return this.getMaxEnergy() + this.getMaxEnergy() * enchant / 2;
        }
        return this.getMaxEnergy();
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean bool) {
        super.func_77624_a(stack, player, tooltip, bool);
        if (StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.formatNumber(this.getEnergyStored(stack)) + " / " + StringHelper.formatNumber(this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.checkLoaded()) {
            ItemStack empty = new ItemStack((Item)this);
            ExchangerHandler.setDefaultTagCompound(empty);
            list.add(empty);
            ItemStack full = new ItemStack((Item)this);
            ExchangerHandler.setDefaultTagCompound(full);
            EnergyHelper.setDefaultEnergyTag(full, this.getMaxEnergyStored(full));
            list.add(full);
        }
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, this);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return ModConfig.misc.holdingEnchantment && Loader.isModLoaded((String)"cofhcore") && enchantment == holding;
    }
}

