/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.util;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyContainerItemWrapper
implements ICapabilityProvider {
    final ItemStack stack;
    final IEnergyContainerItem container;
    final boolean canExtract;
    final boolean canReceive;
    final IEnergyStorage energyCap;

    public EnergyContainerItemWrapper(ItemStack stackIn, IEnergyContainerItem containerIn, boolean extractIn, boolean receiveIn) {
        this.stack = stackIn;
        this.container = containerIn;
        this.canExtract = extractIn;
        this.canReceive = receiveIn;
        this.energyCap = new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return EnergyContainerItemWrapper.this.container.receiveEnergy(EnergyContainerItemWrapper.this.stack, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return EnergyContainerItemWrapper.this.container.extractEnergy(EnergyContainerItemWrapper.this.stack, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return EnergyContainerItemWrapper.this.container.getEnergyStored(EnergyContainerItemWrapper.this.stack);
            }

            public int getMaxEnergyStored() {
                return EnergyContainerItemWrapper.this.container.getMaxEnergyStored(EnergyContainerItemWrapper.this.stack);
            }

            public boolean canExtract() {
                return EnergyContainerItemWrapper.this.canExtract;
            }

            public boolean canReceive() {
                return EnergyContainerItemWrapper.this.canReceive;
            }
        };
    }

    public EnergyContainerItemWrapper(ItemStack stackIn, IEnergyContainerItem containerIn) {
        this(stackIn, containerIn, true, true);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (!this.hasCapability(capability, from)) {
            return null;
        }
        return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyCap);
    }
}

