/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.block;

import java.util.List;
import net.mcreator.kmonsters.procedures.LunarBlossomMobplayerCollidesWithPlantProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StaringGrassBlock
extends DoublePlantBlock {
    public StaringGrassBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.kmonsters.staring_grass.description_0"));
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    private boolean canPlantTypeSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.getBlock() == Blocks.FARMLAND;
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        BlockPos posbelow = pos.below();
        BlockState statebelow = world.getBlockState(posbelow);
        if (blockstate.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            if (blockstate.getBlock() == this) {
                return this.canPlantTypeSurvive(statebelow, world, posbelow);
            }
            return this.mayPlaceOn(statebelow, (BlockGetter)world, posbelow);
        }
        return statebelow.is((Block)this) && statebelow.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        LunarBlossomMobplayerCollidesWithPlantProcedure.execute(blockstate, entity);
    }
}

