/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbatomata<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kmonsters", (String)"modelbatomata"), "main");
    public final ModelPart body;
    public final ModelPart turbine;
    public final ModelPart head;
    public final ModelPart wingL;
    public final ModelPart wingR;

    public Modelbatomata(ModelPart root) {
        this.body = root.getChild("body");
        this.turbine = this.body.getChild("turbine");
        this.head = root.getChild("head");
        this.wingL = root.getChild("wingL");
        this.wingR = root.getChild("wingR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -7.0f, -7.0f, 8.0f, 7.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition turbine = body.addOrReplaceChild("turbine", CubeListBuilder.create().texOffs(42, 26).addBox(-1.0f, -3.5f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)6.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 14).addBox(-3.0f, -1.781f, -5.5446f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.781f, (float)-7.4554f));
        PartDefinition ear_r1 = head.addOrReplaceChild("ear_r1", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -8.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.1f, (float)-0.781f, (float)-1.0446f, (float)-0.7854f, (float)-0.6109f, (float)0.0f));
        PartDefinition ear_r2 = head.addOrReplaceChild("ear_r2", CubeListBuilder.create().texOffs(0, 35).mirror().addBox(0.0f, -8.0f, -1.5f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.1f, (float)-0.781f, (float)-1.0446f, (float)-0.7854f, (float)0.6109f, (float)0.0f));
        PartDefinition wingL = partdefinition.addOrReplaceChild("wingL", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -7.5f, 21.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)20.0f, (float)-0.5f));
        PartDefinition wingR = partdefinition.addOrReplaceChild("wingR", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-20.5f, 0.0f, -7.0f, 21.0f, 0.0f, 14.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)20.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)80, (int)48);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.wingL.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.wingR.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.turbine.zRot = ageInTicks;
        this.wingR.zRot = Mth.sin((float)(ageInTicks * 0.6f)) * 0.6f;
        this.wingL.zRot = Mth.sin((float)(ageInTicks * 0.6f + 3.0f)) * 0.6f;
    }
}

