/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelfreeper<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kmonsters", (String)"modelfreeper"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart leg0;
    public final ModelPart leg1;
    public final ModelPart leg2;
    public final ModelPart leg3;

    public Modelfreeper(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leg0 = root.getChild("leg0");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 28).addBox(-4.0f, -0.6569f, -0.9095f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.6569f, (float)-1.0905f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 28).addBox(-4.0f, -9.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3431f, (float)1.4905f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -7.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-4.0f, 2.0f, -7.5f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 8).addBox(4.0f, -8.0f, -3.5f, 11.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 8).mirror().addBox(-15.0f, -8.0f, -3.5f, 11.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.5f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(33, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.0f, (float)4.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(33, 17).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)18.0f, (float)4.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(33, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.0f, (float)-4.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(33, 17).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)18.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg0.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg0.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

