/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Modelgawker<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kmonsters", (String)"modelgawker"), "main");
    public final ModelPart head;
    public final ModelPart antennae;
    public final ModelPart bottom;

    public Modelgawker(ModelPart root) {
        this.head = root.getChild("head");
        this.antennae = this.head.getChild("antennae");
        this.bottom = root.getChild("bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition antennae = head.addOrReplaceChild("antennae", CubeListBuilder.create().texOffs(0, 1).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.4714f, (float)0.1381f));
        PartDefinition antenna_r1 = antennae.addOrReplaceChild("antenna_r1", CubeListBuilder.create().texOffs(-6, 18).addBox(-2.0f, 0.0f, -3.0f, 8.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition antenna_r2 = antennae.addOrReplaceChild("antenna_r2", CubeListBuilder.create().texOffs(-6, 18).mirror().addBox(-7.0f, 0.0f, -2.0f, 8.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition bottom = partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(34, 0).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 21).addBox(-2.0f, 7.5f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 21).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.antennae.yRot = ageInTicks / 20.0f;
    }
}

