/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.entity;

import javax.annotation.Nullable;
import net.mcreator.kmonsters.init.KmonstersModEntities;
import net.mcreator.kmonsters.procedures.CustomMonsterSpawnProcedure;
import net.mcreator.kmonsters.procedures.FreeperIgnateConditionProcedure;
import net.mcreator.kmonsters.procedures.RedeadOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FreeperEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_Advanced = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Boom = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_SoundCooldown = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Ignited = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Power = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Skin = SynchedEntityData.defineId(FreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public FreeperEntity(EntityType<FreeperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Advanced, (Object)false);
        builder.define(DATA_Boom, (Object)30);
        builder.define(DATA_SoundCooldown, (Object)30);
        builder.define(DATA_Ignited, (Object)false);
        builder.define(DATA_Power, (Object)4);
        builder.define(DATA_Skin, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<Fox>((PathfinderMob)this, Fox.class, 12.0f, 1.0, 1.8){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FreeperEntity.this.getX();
                double y = FreeperEntity.this.getY();
                double z = FreeperEntity.this.getZ();
                FreeperEntity entity = FreeperEntity.this;
                Level world = FreeperEntity.this.level();
                return super.canContinueToUse() && FreeperIgnateConditionProcedure.execute((Entity)entity);
            }
        });
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.goat.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:freeper_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:freeper_dies"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CustomMonsterSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataAdvanced", ((Boolean)this.entityData.get(DATA_Advanced)).booleanValue());
        compound.putInt("DataBoom", ((Integer)this.entityData.get(DATA_Boom)).intValue());
        compound.putInt("DataSoundCooldown", ((Integer)this.entityData.get(DATA_SoundCooldown)).intValue());
        compound.putBoolean("DataIgnited", ((Boolean)this.entityData.get(DATA_Ignited)).booleanValue());
        compound.putInt("DataPower", ((Integer)this.entityData.get(DATA_Power)).intValue());
        compound.putInt("DataSkin", ((Integer)this.entityData.get(DATA_Skin)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataAdvanced")) {
            this.entityData.set(DATA_Advanced, (Object)compound.getBoolean("DataAdvanced"));
        }
        if (compound.contains("DataBoom")) {
            this.entityData.set(DATA_Boom, (Object)compound.getInt("DataBoom"));
        }
        if (compound.contains("DataSoundCooldown")) {
            this.entityData.set(DATA_SoundCooldown, (Object)compound.getInt("DataSoundCooldown"));
        }
        if (compound.contains("DataIgnited")) {
            this.entityData.set(DATA_Ignited, (Object)compound.getBoolean("DataIgnited"));
        }
        if (compound.contains("DataPower")) {
            this.entityData.set(DATA_Power, (Object)compound.getInt("DataPower"));
        }
        if (compound.contains("DataSkin")) {
            this.entityData.set(DATA_Skin, (Object)compound.getInt("DataSkin"));
        }
    }

    public void baseTick() {
        super.baseTick();
        RedeadOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)KmonstersModEntities.FREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.22);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        return builder;
    }
}

