/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.entity;

import java.util.EnumSet;
import net.mcreator.kmonsters.entity.GazerBeamEntity;
import net.mcreator.kmonsters.init.KmonstersModEntities;
import net.mcreator.kmonsters.procedures.GazerNaturalEntitySpawningConditionProcedure;
import net.mcreator.kmonsters.procedures.GazerOnEntityTickUpdateProcedure;
import net.mcreator.kmonsters.procedures.ReturnGazerBlindProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GazerEntity
extends Monster
implements RangedAttackMob {
    public static final EntityDataAccessor<Boolean> DATA_Advanced = SynchedEntityData.defineId(GazerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Blink = SynchedEntityData.defineId(GazerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Blind = SynchedEntityData.defineId(GazerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public GazerEntity(EntityType<GazerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Advanced, (Object)false);
        builder.define(DATA_Blink, (Object)0);
        builder.define(DATA_Blind, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canContinueToUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                if (GazerEntity.this.getTarget() != null && !GazerEntity.this.getMoveControl().hasWanted()) {
                    double x = GazerEntity.this.getX();
                    double y = GazerEntity.this.getY();
                    double z = GazerEntity.this.getZ();
                    GazerEntity entity = GazerEntity.this;
                    Level world = GazerEntity.this.level();
                    return ReturnGazerBlindProcedure.execute((Entity)entity);
                }
                return false;
            }

            public boolean canContinueToUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return ReturnGazerBlindProcedure.execute((Entity)entity) && GazerEntity.this.getMoveControl().hasWanted() && GazerEntity.this.getTarget() != null && GazerEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = GazerEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                GazerEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }

            public void tick() {
                LivingEntity livingentity = GazerEntity.this.getTarget();
                if (GazerEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    GazerEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = GazerEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 20.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        GazerEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = GazerEntity.this.getRandom();
                double dir_x = GazerEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = GazerEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = GazerEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canContinueToUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GazerEntity.this.getX();
                double y = GazerEntity.this.getY();
                double z = GazerEntity.this.getZ();
                GazerEntity entity = GazerEntity.this;
                Level world = GazerEntity.this.level();
                return super.canContinueToUse() && ReturnGazerBlindProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 80, 20.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:gazer_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:gazer_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataAdvanced", ((Boolean)this.entityData.get(DATA_Advanced)).booleanValue());
        compound.putInt("DataBlink", ((Integer)this.entityData.get(DATA_Blink)).intValue());
        compound.putBoolean("DataBlind", ((Boolean)this.entityData.get(DATA_Blind)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataAdvanced")) {
            this.entityData.set(DATA_Advanced, (Object)compound.getBoolean("DataAdvanced"));
        }
        if (compound.contains("DataBlink")) {
            this.entityData.set(DATA_Blink, (Object)compound.getInt("DataBlink"));
        }
        if (compound.contains("DataBlind")) {
            this.entityData.set(DATA_Blind, (Object)compound.getBoolean("DataBlind"));
        }
    }

    public void baseTick() {
        super.baseTick();
        GazerOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        GazerBeamEntity.shoot((LivingEntity)this, target);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)KmonstersModEntities.GAZER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return GazerNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 15.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

