/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.mcreator.kmonsters.entity.VampireFireballEntity;
import net.mcreator.kmonsters.init.KmonstersModBlocks;
import net.mcreator.kmonsters.init.KmonstersModEntities;
import net.mcreator.kmonsters.procedures.BatomataIsSittingProcedure;
import net.mcreator.kmonsters.procedures.MechaVampireEntityDiesProcedure;
import net.mcreator.kmonsters.procedures.MechaVampireEntityIsHurtProcedure;
import net.mcreator.kmonsters.procedures.TameableBatomataOnEntityTickUpdateProcedure;
import net.mcreator.kmonsters.procedures.TameableBatomataOnInitialEntitySpawnProcedure;
import net.mcreator.kmonsters.procedures.TameableBatomataRightClickedOnEntityProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TameableBatomataEntity
extends TamableAnimal
implements RangedAttackMob {
    public static final EntityDataAccessor<Integer> DATA_Skin = SynchedEntityData.defineId(TameableBatomataEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Sit = SynchedEntityData.defineId(TameableBatomataEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Cooldown = SynchedEntityData.defineId(TameableBatomataEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Metal = SynchedEntityData.defineId(TameableBatomataEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public TameableBatomataEntity(EntityType<TameableBatomataEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Skin, (Object)0);
        builder.define(DATA_Sit, (Object)false);
        builder.define(DATA_Cooldown, (Object)0);
        builder.define(DATA_Metal, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                if (TameableBatomataEntity.this.getTarget() != null && !TameableBatomataEntity.this.getMoveControl().hasWanted()) {
                    double x = TameableBatomataEntity.this.getX();
                    double y = TameableBatomataEntity.this.getY();
                    double z = TameableBatomataEntity.this.getZ();
                    TameableBatomataEntity entity = TameableBatomataEntity.this;
                    Level world = TameableBatomataEntity.this.level();
                    return BatomataIsSittingProcedure.execute((Entity)entity);
                }
                return false;
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return BatomataIsSittingProcedure.execute((Entity)entity) && TameableBatomataEntity.this.getMoveControl().hasWanted() && TameableBatomataEntity.this.getTarget() != null && TameableBatomataEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = TameableBatomataEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                TameableBatomataEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }

            public void tick() {
                LivingEntity livingentity = TameableBatomataEntity.this.getTarget();
                if (TameableBatomataEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    TameableBatomataEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = TameableBatomataEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        TameableBatomataEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = TameableBatomataEntity.this.getRandom();
                double dir_x = TameableBatomataEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = TameableBatomataEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = TameableBatomataEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TameableBatomataEntity.this.getX();
                double y = TameableBatomataEntity.this.getY();
                double z = TameableBatomataEntity.this.getZ();
                TameableBatomataEntity entity = TameableBatomataEntity.this;
                Level world = TameableBatomataEntity.this.level();
                return super.canContinueToUse() && BatomataIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 30, 15.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.2f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:batomata_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.anvil.destroy"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TameableBatomataEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        MechaVampireEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity);
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        MechaVampireEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        TameableBatomataOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataSkin", ((Integer)this.entityData.get(DATA_Skin)).intValue());
        compound.putBoolean("DataSit", ((Boolean)this.entityData.get(DATA_Sit)).booleanValue());
        compound.putInt("DataCooldown", ((Integer)this.entityData.get(DATA_Cooldown)).intValue());
        compound.putInt("DataMetal", ((Integer)this.entityData.get(DATA_Metal)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataSkin")) {
            this.entityData.set(DATA_Skin, (Object)compound.getInt("DataSkin"));
        }
        if (compound.contains("DataSit")) {
            this.entityData.set(DATA_Sit, (Object)compound.getBoolean("DataSit"));
        }
        if (compound.contains("DataCooldown")) {
            this.entityData.set(DATA_Cooldown, (Object)compound.getInt("DataCooldown"));
        }
        if (compound.contains("DataMetal")) {
            this.entityData.set(DATA_Metal, (Object)compound.getInt("DataMetal"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        sourceentity.startRiding((Entity)this);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        TameableBatomataEntity entity = this;
        Level world = this.level();
        TameableBatomataRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        TameableBatomataOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        VampireFireballEntity.shoot((LivingEntity)this, target);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        TameableBatomataEntity retval = (TameableBatomataEntity)((EntityType)KmonstersModEntities.TAMEABLE_BATOMATA.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)KmonstersModBlocks.CURSED_LANTERN_LAND.get())}).test(stack);
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            double d0;
            double d1;
            float f1;
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = 0.0f;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.getX() - this.xo) * d1 + (d0 = this.getZ() - this.zo) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f1 - this.walkAnimation.speed()) * 0.4f);
            this.walkAnimation.position(this.walkAnimation.position() + this.walkAnimation.speed());
            this.calculateEntityAnimation(true);
            return;
        }
        super.travel(dir);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

