/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.entity;

import javax.annotation.Nullable;
import net.mcreator.kmonsters.init.KmonstersModBlocks;
import net.mcreator.kmonsters.init.KmonstersModEntities;
import net.mcreator.kmonsters.procedures.CustomMonsterSpawnProcedure;
import net.mcreator.kmonsters.procedures.RedeadOnEntityTickUpdateProcedure;
import net.mcreator.kmonsters.procedures.TerrorChickIsSittingProcedure;
import net.mcreator.kmonsters.procedures.TerrorChickIsTamedProcedure;
import net.mcreator.kmonsters.procedures.TerrorChickRightClickedOnEntityProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TerrorChickEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_Skin = SynchedEntityData.defineId(TerrorChickEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_LifeTime = SynchedEntityData.defineId(TerrorChickEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Sit = SynchedEntityData.defineId(TerrorChickEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> DATA_Bow = SynchedEntityData.defineId(TerrorChickEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public TerrorChickEntity(EntityType<TerrorChickEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Skin, (Object)0);
        builder.define(DATA_LifeTime, (Object)1000);
        builder.define(DATA_Sit, (Object)false);
        builder.define(DATA_Bow, (Object)"Default");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false, false){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new LeapAtTargetGoal((Mob)this, 0.2f){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TerrorChickEntity.this.getX();
                double y = TerrorChickEntity.this.getY();
                double z = TerrorChickEntity.this.getZ();
                TerrorChickEntity entity = TerrorChickEntity.this;
                Level world = TerrorChickEntity.this.level();
                return super.canContinueToUse() && TerrorChickIsSittingProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:terror_chick_idle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.skeleton.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:terror_chick_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:terror_chick_hurt"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CustomMonsterSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataSkin", ((Integer)this.entityData.get(DATA_Skin)).intValue());
        compound.putInt("DataLifeTime", ((Integer)this.entityData.get(DATA_LifeTime)).intValue());
        compound.putBoolean("DataSit", ((Boolean)this.entityData.get(DATA_Sit)).booleanValue());
        compound.putString("DataBow", (String)this.entityData.get(DATA_Bow));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataSkin")) {
            this.entityData.set(DATA_Skin, (Object)compound.getInt("DataSkin"));
        }
        if (compound.contains("DataLifeTime")) {
            this.entityData.set(DATA_LifeTime, (Object)compound.getInt("DataLifeTime"));
        }
        if (compound.contains("DataSit")) {
            this.entityData.set(DATA_Sit, (Object)compound.getBoolean("DataSit"));
        }
        if (compound.contains("DataBow")) {
            this.entityData.set(DATA_Bow, (Object)compound.getString("DataBow"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        TerrorChickEntity entity = this;
        Level world = this.level();
        TerrorChickRightClickedOnEntityProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        RedeadOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        TerrorChickEntity retval = (TerrorChickEntity)((EntityType)KmonstersModEntities.TERROR_CHICK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)KmonstersModBlocks.SOLID_SLUDGE.get())}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 5.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.2);
        return builder;
    }
}

