/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.entity;

import javax.annotation.Nullable;
import net.mcreator.kmonsters.init.KmonstersModEntities;
import net.mcreator.kmonsters.procedures.CustomMonsterSpawnProcedure;
import net.mcreator.kmonsters.procedures.TurnopeDisplayFlowers1Procedure;
import net.mcreator.kmonsters.procedures.TurnopeOnEntityTickUpdateProcedure;
import net.mcreator.kmonsters.procedures.TurnopeSizeModifyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TurnopeEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_Size = SynchedEntityData.defineId(TurnopeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Skin = SynchedEntityData.defineId(TurnopeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Flowers = SynchedEntityData.defineId(TurnopeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_leaves = SynchedEntityData.defineId(TurnopeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Advanced = SynchedEntityData.defineId(TurnopeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TurnopeEntity(EntityType<TurnopeEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Size, (Object)1);
        builder.define(DATA_Skin, (Object)0);
        builder.define(DATA_Flowers, (Object)0);
        builder.define(DATA_leaves, (Object)0);
        builder.define(DATA_Advanced, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<Bee>((PathfinderMob)this, Bee.class, 12.0f, 1.0, 2.0){

            public boolean canUse() {
                double x = TurnopeEntity.this.getX();
                double y = TurnopeEntity.this.getY();
                double z = TurnopeEntity.this.getZ();
                TurnopeEntity entity = TurnopeEntity.this;
                Level world = TurnopeEntity.this.level();
                return super.canUse() && TurnopeDisplayFlowers1Procedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TurnopeEntity.this.getX();
                double y = TurnopeEntity.this.getY();
                double z = TurnopeEntity.this.getZ();
                TurnopeEntity entity = TurnopeEntity.this;
                Level world = TurnopeEntity.this.level();
                return super.canContinueToUse() && TurnopeDisplayFlowers1Procedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Villager.class, 12.0f, 1.0, 2.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, WanderingTrader.class, 12.0f, 1.0, 2.0));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Silverfish.class, 12.0f, 1.0, 2.0));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Rabbit.class, 12.0f, 1.0, 2.0));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false));
        this.goalSelector.addGoal(8, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(10, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(12, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:turnope_idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:turnip_pull"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"kmonsters:turnope_death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CustomMonsterSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataSize", ((Integer)this.entityData.get(DATA_Size)).intValue());
        compound.putInt("DataSkin", ((Integer)this.entityData.get(DATA_Skin)).intValue());
        compound.putInt("DataFlowers", ((Integer)this.entityData.get(DATA_Flowers)).intValue());
        compound.putInt("Dataleaves", ((Integer)this.entityData.get(DATA_leaves)).intValue());
        compound.putBoolean("DataAdvanced", ((Boolean)this.entityData.get(DATA_Advanced)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataSize")) {
            this.entityData.set(DATA_Size, (Object)compound.getInt("DataSize"));
        }
        if (compound.contains("DataSkin")) {
            this.entityData.set(DATA_Skin, (Object)compound.getInt("DataSkin"));
        }
        if (compound.contains("DataFlowers")) {
            this.entityData.set(DATA_Flowers, (Object)compound.getInt("DataFlowers"));
        }
        if (compound.contains("Dataleaves")) {
            this.entityData.set(DATA_leaves, (Object)compound.getInt("Dataleaves"));
        }
        if (compound.contains("DataAdvanced")) {
            this.entityData.set(DATA_Advanced, (Object)compound.getBoolean("DataAdvanced"));
        }
    }

    public void baseTick() {
        super.baseTick();
        TurnopeOnEntityTickUpdateProcedure.execute((Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        TurnopeEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)TurnopeSizeModifyProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)KmonstersModEntities.TURNOPE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 2.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

