/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.item;

import java.util.List;
import net.mcreator.kmonsters.init.KmonstersModItems;
import net.mcreator.kmonsters.procedures.CruorumMiningProcedure;
import net.mcreator.kmonsters.procedures.KodachiToolInInventoryTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CruorumHoeItem
extends HoeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 666;
        }

        public float getSpeed() {
            return 7.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)KmonstersModItems.CRUORUM_INGOT.get())});
        }
    };

    public CruorumHoeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)0.0f, (float)-1.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        CruorumMiningProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate, (Entity)entity, itemstack);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.kmonsters.cruorum_hoe.description_0"));
        list.add((Component)Component.translatable((String)"item.kmonsters.cruorum_hoe.description_1"));
        list.add((Component)Component.translatable((String)"item.kmonsters.cruorum_hoe.description_2"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        KodachiToolInInventoryTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
    }
}

