/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kmonsters.item;

import java.util.List;
import net.mcreator.kmonsters.procedures.TerrorStaffActiveLivingEntityIsHitWithToolProcedure;
import net.mcreator.kmonsters.procedures.TerrorStaffActiveRightclickedOnBlockProcedure;
import net.mcreator.kmonsters.procedures.TerrorStaffBlueBlockDestroyedWithToolProcedure;
import net.mcreator.kmonsters.procedures.TerrorStaffToolInHandTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TerrorStaffActiveItem
extends PickaxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 500;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public TerrorStaffActiveItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)5.0f, (float)-3.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        TerrorStaffBlueBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate, itemstack);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        TerrorStaffActiveLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.kmonsters.terror_staff_active.description_0"));
        list.add((Component)Component.translatable((String)"item.kmonsters.terror_staff_active.description_1"));
        list.add((Component)Component.translatable((String)"item.kmonsters.terror_staff_active.description_2"));
        list.add((Component)Component.translatable((String)"item.kmonsters.terror_staff_active.description_3"));
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        TerrorStaffActiveRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), context.getClickedFace(), (Entity)context.getPlayer(), context.getItemInHand());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            TerrorStaffToolInHandTickProcedure.execute(entity, itemstack);
        }
    }
}

