/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.capabilities;

import com.vandendaelen.depthmeter.capabilities.IDepth;
import com.vandendaelen.depthmeter.misc.DepthLevels;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DepthCapability
implements IDepth {
    private DepthLevels depth = DepthLevels.VOID;
    private int posSeaLevel = 0;

    @Override
    public void tick(Player playerEntity) {
        if (playerEntity instanceof ServerPlayer) {
            ResourceLocation currentDimension = ((ServerPlayer)playerEntity).m_183503_().m_46472_().m_135782_();
            int seaLevel = ((ServerPlayer)playerEntity).m_183503_().m_5736_();
            this.depth = currentDimension == Level.f_46429_.m_135782_() ? DepthLevels.LAVA : (currentDimension == Level.f_46430_.m_135782_() ? DepthLevels.VOID : DepthLevels.from(playerEntity.m_146904_()));
            this.posSeaLevel = playerEntity.m_146904_() - seaLevel;
            this.serializeNBT();
        }
    }

    @Override
    public DepthLevels getDepth() {
        return this.depth;
    }

    @Override
    public int getPosSeaLevel() {
        return this.posSeaLevel;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("depth", (float)this.depth.ordinal());
        tag.m_128405_("pos_sea_level", this.posSeaLevel);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.depth = DepthLevels.values()[(int)nbt.m_128457_("depth")];
        this.posSeaLevel = nbt.m_128451_("pos_sea_level");
    }
}

