/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.items;

import com.vandendaelen.depthmeter.capabilities.DepthMeterCapabilities;
import com.vandendaelen.depthmeter.capabilities.IDepth;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DepthMeterItem
extends Item {
    private static final String DEPTH = "depth";

    public DepthMeterItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.m_5776_()) {
            if (entityIn instanceof ServerPlayer) {
                stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> cap.tick((Player)entityIn));
            }
            if (worldIn.m_46467_() % 20L == 0L) {
                DepthMeterItem.syncCapability(stack);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> tooltip.add((Component)this.getDepthInformation((IDepth)cap).m_130940_(ChatFormatting.GRAY)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        playerIn.m_21120_(handIn).getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> playerIn.m_5661_((Component)this.getDepthInformation((IDepth)cap), true));
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public TranslatableComponent getDepthInformation(IDepth cap) {
        int posSeaLevel = cap.getPosSeaLevel();
        if (posSeaLevel >= 0) {
            return new TranslatableComponent("depthmeter.sea_level_above", new Object[]{String.valueOf(Math.abs(posSeaLevel))});
        }
        return new TranslatableComponent("depthmeter.sea_level_below", new Object[]{String.valueOf(Math.abs(posSeaLevel))});
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.m_41784_().m_128391_(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.m_41784_());
        }
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(handler -> tag.m_128365_("cap_sync", handler.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.m_128441_("cap_sync")) {
            stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(handler -> handler.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("cap_sync"))));
        }
    }
}

