/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.capabilities;

import com.vandendaelen.depthmeter.capabilities.IDepth;
import com.vandendaelen.depthmeter.misc.DepthLevels;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Dimension;

public class DepthCapability
implements IDepth {
    private DepthLevels depth = DepthLevels.VOID;
    private int posSeaLevel = 0;

    @Override
    public void tick(PlayerEntity playerEntity) {
        if (playerEntity instanceof ServerPlayerEntity) {
            ResourceLocation currentDimension = ((ServerPlayerEntity)playerEntity).func_71121_q().func_234923_W_().func_240901_a_();
            int seaLevel = ((ServerPlayerEntity)playerEntity).func_71121_q().func_181545_F();
            this.depth = currentDimension == Dimension.field_236054_c_.func_240901_a_() ? DepthLevels.LAVA : (currentDimension == Dimension.field_236055_d_.func_240901_a_() ? DepthLevels.VOID : DepthLevels.from((int)playerEntity.func_226278_cu_()));
            this.posSeaLevel = (int)playerEntity.func_226278_cu_() - seaLevel;
            this.serializeNBT();
        }
    }

    @Override
    public DepthLevels getDepth() {
        return this.depth;
    }

    @Override
    public int getPosSeaLevel() {
        return this.posSeaLevel;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74776_a("depth", (float)this.depth.ordinal());
        tag.func_74768_a("pos_sea_level", this.posSeaLevel);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.depth = DepthLevels.values()[(int)nbt.func_74760_g("depth")];
        this.posSeaLevel = nbt.func_74762_e("pos_sea_level");
    }
}

