/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.capabilities;

import com.vandendaelen.depthmeter.capabilities.DepthCapability;
import com.vandendaelen.depthmeter.capabilities.DepthMeterCapabilities;
import com.vandendaelen.depthmeter.misc.DepthLevels;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface IDepth
extends INBTSerializable<CompoundNBT> {
    public void tick(PlayerEntity var1);

    public DepthLevels getDepth();

    public int getPosSeaLevel();

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private IDepth depth;

        public Provider(IDepth depth) {
            this.depth = depth;
        }

        public Provider() {
            this.depth = new DepthCapability();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == DepthMeterCapabilities.DEPTH ? LazyOptional.of(() -> this.depth) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.depth.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.depth.deserializeNBT((INBT)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IDepth> {
        @Nullable
        public INBT writeNBT(Capability<IDepth> capability, IDepth instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IDepth> capability, IDepth instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

