/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DepthMeterConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 256;

    public static int getLimitVoidToLava() {
        return (Integer)DepthMeterConfig.COMMON.limitVoidToLava.get();
    }

    public static int getLimitLavaToCave() {
        return (Integer)DepthMeterConfig.COMMON.limitLavaToCave.get();
    }

    public static int getLimitCaveToSurface() {
        return (Integer)DepthMeterConfig.COMMON.limitCaveToSurface.get();
    }

    public static int getLimitSurfaceToSky() {
        return (Integer)DepthMeterConfig.COMMON.limitSurfaceToSky.get();
    }

    static {
        Pair specClientPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specClientPair.getRight();
        COMMON = (Common)specClientPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue limitVoidToLava;
        public final ForgeConfigSpec.IntValue limitLavaToCave;
        public final ForgeConfigSpec.IntValue limitCaveToSurface;
        public final ForgeConfigSpec.IntValue limitSurfaceToSky;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Limits settings");
            this.limitVoidToLava = builder.comment("Y level for Void/Lava junction").defineInRange("limitVoidToLava", 0, 0, 256);
            this.limitLavaToCave = builder.comment(new String[]{"Y level for Lava/Cave junction", "Constraint : limitLavaToCave > limitVoidToLava"}).defineInRange("limitLavaToCave", 13, 0, 256);
            this.limitCaveToSurface = builder.comment(new String[]{"Y level for Cave/Surface junction", "Constraint : limitCaveToSurface > limitLavaToCave"}).defineInRange("limitCaveToSurface", 51, 0, 256);
            this.limitSurfaceToSky = builder.comment(new String[]{"Y level for Surface/Sky junction", "Constraint : limitSurfaceToSky > limitCaveToSurface"}).defineInRange("limitSurfaceToSky", 129, 0, 256);
            builder.pop();
        }
    }
}

