/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.depthmeter.items;

import com.vandendaelen.depthmeter.capabilities.DepthMeterCapabilities;
import com.vandendaelen.depthmeter.capabilities.IDepth;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class DepthMeterItem
extends Item {
    private static final String DEPTH = "depth";

    public DepthMeterItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.func_201670_d()) {
            if (entityIn instanceof ServerPlayerEntity) {
                stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> cap.tick((PlayerEntity)entityIn));
            }
            if (worldIn.func_82737_E() % 20L == 0L) {
                DepthMeterItem.syncCapability(stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> tooltip.add((ITextComponent)this.getDepthInformation((IDepth)cap).func_240699_a_(TextFormatting.GRAY)));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184586_b(handIn).getCapability(DepthMeterCapabilities.DEPTH).ifPresent(cap -> playerIn.func_146105_b((ITextComponent)this.getDepthInformation((IDepth)cap), true));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public TranslationTextComponent getDepthInformation(IDepth cap) {
        int posSeaLevel = cap.getPosSeaLevel();
        if (posSeaLevel >= 0) {
            return new TranslationTextComponent("depthmeter.sea_level_above", new Object[]{String.valueOf(Math.abs(posSeaLevel))});
        }
        return new TranslationTextComponent("depthmeter.sea_level_below", new Object[]{String.valueOf(Math.abs(posSeaLevel))});
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.func_196082_o().func_197643_a(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.func_196082_o());
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(handler -> tag.func_218657_a("cap_sync", handler.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("cap_sync")) {
            stack.getCapability(DepthMeterCapabilities.DEPTH).ifPresent(handler -> handler.deserializeNBT((INBT)nbt.func_74775_l("cap_sync")));
        }
    }
}

