/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.blocks.FrameType;
import com.ldtteam.storageracks.blocks.UpgradeableBlock;
import com.ldtteam.storageracks.gui.WindowHutAllInventory;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends UpgradeableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final int tier;
    private final Item buildMaterial;

    public ControllerBlock(Item material, Item upgradeCost, int tier) {
        super(upgradeCost);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.tier = tier;
        this.buildMaterial = material;
    }

    @Override
    public Block getNext() {
        if (this.tier >= FrameType.values().length) {
            return null;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("storageracks", FrameType.values()[this.tier + 1].m_7912_() + "_controller"));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        @NotNull Direction facing = context.m_43723_() == null ? Direction.NORTH : Direction.m_122364_((double)context.m_43723_().f_19859_);
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, world, tooltip, flag);
        tooltip.add((Component)Component.m_237110_((String)"block.storageracks.controllertoolip", (Object[])new Object[]{this.tier * 20}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213646_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean check) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((TileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (Level)worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_213646_(state, worldIn, pos, stack, check);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (world.f_46443_) {
            new WindowHutAllInventory((TileEntityController)world.m_7702_(pos)).open();
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityController(blockPos, blockState);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && state.m_60734_() instanceof ControllerBlock && placer instanceof Player) {
            ((TileEntityController)world.m_7702_(pos)).setTier(this.tier);
            for (Direction direction : Direction.values()) {
                BlockEntity te = world.m_7702_(pos.m_121945_(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
                return;
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean rem = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.f_46443_ && state.m_60734_() instanceof ControllerBlock) {
            for (Direction direction : Direction.values()) {
                BlockEntity te = world.m_7702_(pos.m_121945_(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
            }
        }
        return rem;
    }

    public Item getBuildMaterial() {
        return this.buildMaterial;
    }

    public int getTier() {
        return this.tier;
    }
}

