/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.RackType;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class BlockModelProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<Tuple<BlockModelJson, String>> models = new ArrayList<Tuple<BlockModelJson, String>>();

    public BlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        for (RegistryObject<CornerBlock> registryObject : ModBlocks.corners) {
            BlockModelJson modelJson = new BlockModelJson();
            modelJson.setParent("storageracks:block/corner");
            HashMap<String, CallSite> textureMap = new HashMap<String, CallSite>();
            textureMap.put("0", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            textureMap.put("1", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getFrameType().getMaterial()).m_135815_())));
            textureMap.put("particle", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
            modelJson.setTextures(textureMap);
            String name = ((CornerBlock)((Object)registryObject.get())).getWoodType().m_7912_().toLowerCase(Locale.ROOT) + "_" + ((CornerBlock)((Object)registryObject.get())).getFrameType().m_7912_().toLowerCase(Locale.ROOT) + "_corner.json";
            this.models.add((Tuple<BlockModelJson, String>)new Tuple((Object)modelJson, (Object)name));
        }
        for (RegistryObject registryObject : ModBlocks.racks) {
            for (RackType type : RackType.values()) {
                BlockModelJson modelJson = new BlockModelJson();
                modelJson.setParent("storageracks:block/rack" + type.getName());
                HashMap<String, CallSite> textureMap = new HashMap<String, CallSite>();
                textureMap.put("0", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
                textureMap.put("1", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getFrameType().getMaterial()).m_135815_())));
                textureMap.put("particle", (CallSite)((Object)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((RackBlock)((Object)registryObject.get())).getWoodType().getMaterial()).m_135815_())));
                modelJson.setTextures(textureMap);
                String name = ((RackBlock)((Object)registryObject.get())).getWoodType().m_7912_().toLowerCase(Locale.ROOT) + "_" + ((RackBlock)((Object)registryObject.get())).getFrameType().m_7912_().toLowerCase(Locale.ROOT) + "_rack" + type.getName() + ".json";
                this.models.add((Tuple<BlockModelJson, String>)new Tuple((Object)modelJson, (Object)name));
            }
        }
        return this.generateAll(cache);
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.models.size()];
        int i = 0;
        for (Tuple<BlockModelJson, String> model : this.models) {
            Path target = this.getPath((String)model.m_14419_());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((BlockModelJson)model.m_14418_()).serialize(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(String name) {
        return this.generator.getPackOutput().m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("storageracks").resolve("assets/storageracks/models/block/").resolve(name + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Block Model Provider";
    }
}

