/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.datagen;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import com.ldtteam.storageracks.blocks.ControllerBlock;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.ModBlocks;
import com.ldtteam.storageracks.blocks.RackBlock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RecipeProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<Tuple<ShapedRecipeJson, String>> models = new ArrayList<Tuple<ShapedRecipeJson, String>>();

    public RecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        ShapedRecipeJson json;
        HashMap<String, RecipeIngredientKeyJson> keys;
        ShapedPatternJson pattern;
        for (RegistryObject<RackBlock> registryObject : ModBlocks.racks) {
            pattern = new ShapedPatternJson("FFF", "XCX", "FFF");
            keys = new HashMap<String, RecipeIngredientKeyJson>();
            keys.put("F", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)((RackBlock)((Object)registryObject.get())).getWoodType().getMaterial().m_5456_()).toString(), false)));
            keys.put("C", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)((RackBlock)((Object)registryObject.get())).frameType.getCreationCost()).toString(), false)));
            keys.put("X", new RecipeIngredientKeyJson(new RecipeIngredientJson(Tags.Items.RODS_WOODEN.f_203868_().toString(), true)));
            json = new ShapedRecipeJson("racks", pattern, keys, new RecipeResultJson(1, ForgeRegistries.ITEMS.getKey((Object)((RackBlock)((Object)registryObject.get())).m_5456_()).toString()));
            this.models.add((Tuple<ShapedRecipeJson, String>)new Tuple((Object)json, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        for (RegistryObject registryObject : ModBlocks.corners) {
            pattern = new ShapedPatternJson("FFF", "FCF", "FFF");
            keys = new HashMap();
            keys.put("F", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)((CornerBlock)((Object)registryObject.get())).getWoodType().getMaterial().m_5456_()).toString(), false)));
            keys.put("C", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)((CornerBlock)((Object)registryObject.get())).frameType.getCreationCost()).toString(), false)));
            json = new ShapedRecipeJson("corners", pattern, keys, new RecipeResultJson(8, ForgeRegistries.ITEMS.getKey((Object)((CornerBlock)((Object)registryObject.get())).m_5456_()).toString()));
            this.models.add((Tuple<ShapedRecipeJson, String>)new Tuple((Object)json, (Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_()));
        }
        this.generateControllerRecipe(cache, (ControllerBlock)((Object)ModBlocks.stoneController.get()), Items.f_42516_);
        this.generateControllerRecipe(cache, (ControllerBlock)((Object)ModBlocks.ironController.get()), ((ControllerBlock)((Object)ModBlocks.stoneController.get())).m_5456_());
        this.generateControllerRecipe(cache, (ControllerBlock)((Object)ModBlocks.goldController.get()), ((ControllerBlock)((Object)ModBlocks.ironController.get())).m_5456_());
        this.generateControllerRecipe(cache, (ControllerBlock)((Object)ModBlocks.emeraldController.get()), ((ControllerBlock)((Object)ModBlocks.goldController.get())).m_5456_());
        this.generateControllerRecipe(cache, (ControllerBlock)((Object)ModBlocks.diamondController.get()), ((ControllerBlock)((Object)ModBlocks.emeraldController.get())).m_5456_());
        return this.generateAll(cache);
    }

    private void generateControllerRecipe(CachedOutput cache, ControllerBlock state, Item prev) {
        ShapedPatternJson pattern = new ShapedPatternJson("SSS", "SPS", "SSS");
        HashMap<String, RecipeIngredientKeyJson> keys = new HashMap<String, RecipeIngredientKeyJson>();
        keys.put("S", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)state.getBuildMaterial()).toString(), false)));
        keys.put("P", new RecipeIngredientKeyJson(new RecipeIngredientJson(ForgeRegistries.ITEMS.getKey((Object)prev).toString(), false)));
        ShapedRecipeJson json = new ShapedRecipeJson("controllers", pattern, keys, new RecipeResultJson(1, ForgeRegistries.ITEMS.getKey((Object)state.m_5456_()).toString()));
        this.models.add((Tuple<ShapedRecipeJson, String>)new Tuple((Object)json, (Object)ForgeRegistries.BLOCKS.getKey((Object)state).m_135815_()));
    }

    protected CompletableFuture<?> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.models.size()];
        int i = 0;
        for (Tuple<ShapedRecipeJson, String> model : this.models) {
            Path target = this.getPath((String)model.m_14419_());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((ShapedRecipeJson)model.m_14418_()).serialize(), (Path)target);
        }
        return CompletableFuture.allOf(futures);
    }

    protected Path getPath(String name) {
        return this.generator.getPackOutput().m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("storageracks").resolve("data/storageracks//recipes/").resolve(name + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Brick Blocks Recipe Provider";
    }
}

