/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.network;

import com.ldtteam.storageracks.network.IMessage;
import com.ldtteam.storageracks.network.OpenInventoryMessage;
import com.ldtteam.storageracks.network.SortControllerMessage;
import com.ldtteam.storageracks.network.UnlockInsertMessage;
import com.ldtteam.storageracks.network.UnlockSortMessage;
import com.ldtteam.storageracks.utils.Log;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("storageracks", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        int idx = 0;
        this.registerMessage(++idx, SortControllerMessage.class, SortControllerMessage::new);
        this.registerMessage(++idx, UnlockSortMessage.class, UnlockSortMessage::new);
        this.registerMessage(++idx, UnlockInsertMessage.class, UnlockInsertMessage::new);
        this.registerMessage(++idx, OpenInventoryMessage.class, OpenInventoryMessage::new);
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Supplier<MSG> msgCreator) {
        this.rawChannel.registerMessage(id, msgClazz, (msg, buf) -> msg.toBytes((FriendlyByteBuf)buf), buf -> {
            IMessage msg = (IMessage)msgCreator.get();
            msg.fromBytes((FriendlyByteBuf)buf);
            return msg;
        }, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            if (msg.getExecutionSide() != null && packetOrigin.equals((Object)msg.getExecutionSide())) {
                Log.getLogger().warn("Receving {} at wrong side!", (Object)msg.getClass().getName());
                return;
            }
            ctx.enqueueWork(() -> msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToServer(IMessage msg) {
        this.rawChannel.sendToServer((Object)msg);
    }

    public void sendToPlayer(IMessage msg, ServerPlayer player) {
        this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToEveryone(IMessage msg) {
        this.rawChannel.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)msg);
    }

    public void sendToTrackingChunk(IMessage msg, LevelChunk chunk) {
        this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }
}

