/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.tileentities;

import com.ldtteam.storageracks.ItemStorage;
import com.ldtteam.storageracks.blocks.CornerBlock;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.RackType;
import com.ldtteam.storageracks.inv.ContainerRack;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.ModTileEntities;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.utils.BlockPosUtil;
import com.ldtteam.storageracks.utils.ItemStackUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private int freeSlots = 0;
    private BlockPos controller;
    private LazyOptional<IItemHandler> lastOptional;

    public TileEntityRack(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.RACK.get(), pos, state);
    }

    public void rotate(Rotation rotationIn) {
        if (this.controller != null) {
            this.controller = this.controller.m_7954_(rotationIn);
        }
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count) {
        ItemStorage checkItem = new ItemStorage(stack);
        return this.content.getOrDefault(checkItem, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack);
        return this.content.getOrDefault(checkItem, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack);
        return this.content.containsKey(checkItem);
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeItemStorage() {
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(this, 18 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Override
    public void updateItemStorage() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.m_6596_();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.m_41777_());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof RackBlock) {
            if (this.content.isEmpty()) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(RackBlock.VARIANT, (Comparable)((Object)RackType.DEFAULT)), 3);
            } else {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(RackBlock.VARIANT, (Comparable)((Object)RackType.FULL)), 3);
            }
        }
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(this, slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        int oldSize = compound.m_128451_("tagSIze");
        this.checkForUpgrade(this.m_58900_(), oldSize);
        this.inventory = this.createInventory(18 + this.size * 9);
        ListTag inventoryTagList = compound.m_128437_("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundTag inventoryCompound = inventoryTagList.m_128728_(i);
            if (inventoryCompound.m_128441_("empty")) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)inventoryCompound);
            this.inventory.setStackInSlot(i, stack);
        }
        this.updateContent();
        this.controllerPos = BlockPosUtil.readFromNBT(compound, "pos");
        this.invalidateCap();
    }

    public void checkForUpgrade(BlockState state, int oldSize) {
        RackBlock block = (RackBlock)state.m_60734_();
        if (block.frameType.m_7912_().contains("stone")) {
            this.size = 1;
        } else if (block.frameType.m_7912_().contains("iron")) {
            this.size = 2;
        } else if (block.frameType.m_7912_().contains("gold")) {
            this.size = 3;
        } else if (block.frameType.m_7912_().contains("emerald")) {
            this.size = 4;
        } else if (block.frameType.m_7912_().contains("diamond")) {
            this.size = 5;
        }
        if (oldSize != this.size) {
            this.upgradeItemStorage();
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("tagSIze", this.size);
        @NotNull ListTag inventoryTagList = new ListTag();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundTag inventoryCompound = new CompoundTag();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) {
                inventoryCompound.m_128379_("empty", true);
            } else {
                stack.m_41739_(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.m_128365_("inventory", (Tag)inventoryTagList);
        BlockPosUtil.writeToNBT(compound, "pos", this.controllerPos);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (!this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.lastOptional != null && this.lastOptional.isPresent()) {
                return this.lastOptional.cast();
            }
            this.lastOptional = LazyOptional.of(() -> {
                if (this.m_58901_()) {
                    return new AbstractTileEntityRack.RackInventory(this, 0);
                }
                return this.getInventory();
            });
            return this.lastOptional.cast();
        }
        return super.getCapability(capability, dir);
    }

    public void m_6596_() {
        WorldUtil.markChunkDirty(this.f_58857_, this.m_58899_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerRack(id, inv, this.m_58899_());
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.title.rack");
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCap();
    }

    private void invalidateCap() {
        if (this.lastOptional != null && this.lastOptional.isPresent()) {
            this.lastOptional.invalidate();
        }
        this.lastOptional = null;
    }

    public int getSize() {
        return this.size;
    }

    public void neighborChange() {
        HashSet<BlockPos> visitedPositions = new HashSet<BlockPos>();
        BlockPos controller = TileEntityRack.visitPositions(this.f_58857_, visitedPositions, this.m_58899_());
        visitedPositions.removeIf(pos -> this.f_58857_.m_8055_(pos).m_60734_() instanceof CornerBlock);
        if (controller != BlockPos.f_121853_ && controller != null) {
            this.controller = this.m_58899_().m_121996_((Vec3i)controller);
            ((TileEntityController)this.f_58857_.m_7702_(controller)).addAll(visitedPositions);
            for (BlockPos pos2 : visitedPositions) {
                if (pos2.equals((Object)controller)) continue;
                ((TileEntityRack)this.f_58857_.m_7702_((BlockPos)pos2)).controller = pos2.m_121996_((Vec3i)controller);
            }
        } else if (controller == null) {
            TileEntityController te;
            BlockPos oldController = null;
            for (BlockPos pos3 : visitedPositions) {
                TileEntityRack rack = (TileEntityRack)this.f_58857_.m_7702_(pos3);
                if (rack.controller == null) continue;
                oldController = rack.m_58899_().m_121996_((Vec3i)rack.controller);
                rack.controller = null;
            }
            if (oldController != null && (te = (TileEntityController)this.f_58857_.m_7702_(oldController)) != null) {
                te.removeAll(visitedPositions);
            }
        }
    }

    public void m_155250_(@NotNull BlockState state) {
        super.m_155250_(state);
        this.invalidateCap();
    }

    public static BlockPos visitPositions(Level level, Set<BlockPos> visitedPositions, BlockPos current) {
        BlockPos controller = null;
        if (level.m_7702_(current) instanceof TileEntityController) {
            controller = current;
        }
        visitedPositions.add(current);
        for (Direction dir : Direction.values()) {
            BlockPos cont;
            BlockEntity te;
            BlockPos next = current.m_121945_(dir);
            if (visitedPositions.contains(next) || !((te = level.m_7702_(next)) instanceof TileEntityRack) && !(te instanceof TileEntityController) && !(level.m_8055_(next).m_60734_() instanceof CornerBlock) || (cont = TileEntityRack.visitPositions(level, visitedPositions, next)) == null) continue;
            if (cont.equals((Object)BlockPos.f_121853_) || controller != null && !cont.equals((Object)controller)) {
                return BlockPos.f_121853_;
            }
            controller = cont;
        }
        return controller;
    }
}

