/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.f_41583_;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();

    private ItemStackUtils() {
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.m_41619_();
    }

    public static Boolean isNotEmpty(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false;
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static int getSize(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.m_41613_();
    }

    public static int getDurability(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.m_41776_() - stack.m_41773_();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1).booleanValue() && ItemStackUtils.isEmpty(itemStack2).booleanValue()) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.m_41720_() != itemStack2.m_41720_() || matchDamage && itemStack1.m_41773_() != itemStack2.m_41773_())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.m_41613_() > itemStack2.m_41613_()) {
                return false;
            }
            if (itemStack1.m_41782_() && itemStack2.m_41782_()) {
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (String key : nbt1.m_128431_()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.m_128441_(key) && nbt1.m_128423_(key).equals(nbt2.m_128423_(key))) continue;
                    return false;
                }
                return nbt1.m_128440_() == nbt2.m_128440_();
            }
            return !(itemStack1.m_41782_() && !itemStack1.m_41783_().m_128456_() || itemStack2.m_41782_() && !itemStack2.m_41783_().m_128456_());
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.m_41764_(stack.m_41613_() + amount);
    }
}

