/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final int MAX_DEBUG_TEXT_RENDER_DIST_SQUARED = 1024;
    public static final RenderType LINES_GLINT = RenderTypes.LINES_GLINT;

    public static void renderBox(BlockPos posA, BlockPos posB, float red, float green, float blue, float alpha, double boxGrow, PoseStack matrixStack, VertexConsumer buffer) {
        double minX = (double)Math.min(posA.m_123341_(), posB.m_123341_()) - boxGrow;
        double minY = (double)Math.min(posA.m_123342_(), posB.m_123342_()) - boxGrow;
        double minZ = (double)Math.min(posA.m_123343_(), posB.m_123343_()) - boxGrow;
        double maxX = (double)(Math.max(posA.m_123341_(), posB.m_123341_()) + 1) + boxGrow;
        double maxY = (double)(Math.max(posA.m_123342_(), posB.m_123342_()) + 1) + boxGrow;
        double maxZ = (double)(Math.max(posA.m_123343_(), posB.m_123343_()) + 1) + boxGrow;
        Vec3 viewPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-viewPosition.f_82479_, -viewPosition.f_82480_, -viewPosition.f_82481_);
        LevelRenderer.m_109608_((PoseStack)matrixStack, (VertexConsumer)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)red, (float)green, (float)blue, (float)alpha);
        matrixStack.m_85849_();
    }

    public static void renderDebugText(BlockPos pos, List<String> text, PoseStack matrixStack, boolean forceWhite, int mergeEveryXListElements, MultiBufferSource buffer) {
        if (mergeEveryXListElements < 1) {
            throw new IllegalArgumentException("mergeEveryXListElements is less than 1");
        }
        EntityRenderDispatcher erm = Minecraft.m_91087_().m_91290_();
        int cap = text.size();
        if (cap > 0 && erm.m_114378_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 1024.0) {
            Vec3 viewPosition = erm.f_114358_.m_90583_();
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.m_123341_() + 0.5 - viewPosition.f_82479_, (double)pos.m_123342_() + 0.75 - viewPosition.f_82480_, (double)pos.m_123343_() + 0.5 - viewPosition.f_82481_);
            matrixStack.m_252781_(erm.m_253208_());
            matrixStack.m_85841_(-0.014f, -0.014f, 0.014f);
            matrixStack.m_85837_(0.0, 18.0, 0.0);
            float backgroundTextOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int alphaMask = (int)(backgroundTextOpacity * 255.0f) << 24;
            Matrix4f rawPosMatrix = matrixStack.m_85850_().m_252922_();
            for (int i = 0; i < cap; i += mergeEveryXListElements) {
                MutableComponent renderText = Component.m_237113_((String)(mergeEveryXListElements == 1 ? text.get(i) : text.subList(i, Math.min(i + mergeEveryXListElements, cap)).toString()));
                float textCenterShift = -fontrenderer.m_92852_((FormattedText)renderText) / 2;
                fontrenderer.m_253181_((Component)renderText, textCenterShift, 0.0f, forceWhite ? -1 : 0x20FFFFFF, false, rawPosMatrix, buffer, true, alphaMask, 0xF000F0);
                if (!forceWhite) {
                    fontrenderer.m_253181_((Component)renderText, textCenterShift, 0.0f, -1, false, rawPosMatrix, buffer, false, 0, 0xF000F0);
                }
                Objects.requireNonNull(fontrenderer);
                matrixStack.m_85837_(0.0, (double)(9 + 1), 0.0);
            }
            matrixStack.m_85849_();
        }
    }

    public static final class RenderTypes
    extends RenderType {
        private static final RenderType LINES_GLINT = RenderTypes.m_173215_((String)"storageracks_lines_glint", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).m_110669_(f_110119_).m_110685_(f_110134_).m_110675_(f_110129_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110111_).m_110691_(false));

        public RenderTypes(String nameIn, VertexFormat formatIn, VertexFormat.Mode drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
            throw new IllegalStateException();
        }
    }
}

