/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.raverbury.aggroindicator.ClientConfig;
import io.github.raverbury.aggroindicator.util.MathHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class AlertRenderer {
    private static final Map<UUID, Boolean> entityUuidSet = new HashMap<UUID, Boolean>();
    private static ResourceLocation aggroIcon = AlertRenderer.getConfiguredAggroIcon(0);

    private AlertRenderer() {
    }

    public static void addAggroingMob(UUID mobUuid, boolean isAboutToAttack) {
        entityUuidSet.put(mobUuid, isAboutToAttack);
    }

    public static void removeAggroingMob(UUID mobUuid) {
        entityUuidSet.remove(mobUuid);
    }

    public static void clearAggroingMobs() {
        entityUuidSet.clear();
    }

    public static void renderAlertIcon(float partialTick, PoseStack matrix, Camera camera) {
        ClientConfig clientConfig = ClientConfig.cachedOrDefault();
        if (!clientConfig.renderAlertIcon) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (entityUuidSet.isEmpty() || camera == null || clientLevel == null || localPlayer == null || localPlayer.hasEffect(MobEffects.BLINDNESS) || localPlayer.hasEffect(MobEffects.DARKNESS)) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        aggroIcon = AlertRenderer.getConfiguredAggroIcon(clientConfig.alertIconStyle);
        List nearbyMobs = clientLevel.getEntitiesOfClass(Mob.class, localPlayer.getBoundingBox().inflate((double)clientConfig.getClampedRenderRange()), mob -> true);
        HashSet<String> blacklistedMobs = clientConfig.getBlacklistLookupTable();
        for (Mob mob2 : nearbyMobs) {
            String entityRegistryName;
            if (!entityUuidSet.containsKey(mob2.getUUID()) || blacklistedMobs.contains(entityRegistryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob2.getType()).toString()) || mob2.hasEffect(MobEffects.INVISIBILITY) || mob2.isInvisible()) continue;
            float scaleToGui = 0.025f;
            boolean sneaking = mob2.isCrouching();
            float height = mob2.getBbHeight() + 0.6f - (sneaking ? 0.25f : 0.0f);
            double x = Mth.lerp((double)partialTick, (double)mob2.xo, (double)mob2.getX());
            double y = Mth.lerp((double)partialTick, (double)mob2.yo, (double)mob2.getY());
            double z = Mth.lerp((double)partialTick, (double)mob2.zo, (double)mob2.getZ());
            Vec3 camPos = camera.getPosition();
            double camX = camPos.x();
            double camY = camPos.y();
            double camZ = camPos.z();
            matrix.pushPose();
            matrix.translate(x - camX, y + (double)height - camY, z - camZ);
            Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
            matrix.mulPose(MathHelper.rotationDegrees(YP, -camera.getYRot()));
            matrix.scale(-scaleToGui, -scaleToGui, scaleToGui);
            if (clientConfig.scaleWithMobSize) {
                float size;
                matrix.scale(size *= (size = (float)mob2.getBoundingBox().getSize()) > 2.0f ? 0.9f : 1.0f, size, size);
            }
            float[] colors = clientConfig.getColors();
            AlertRenderer._render(matrix, clientConfig.getClampedXOffset(), -(7.0f + clientConfig.getClampedYOffset()), clientConfig.getClampedAlertIconSize(), entityUuidSet.get(mob2.getUUID()), colors);
            matrix.popPose();
        }
        RenderSystem.disableBlend();
    }

    private static ResourceLocation getConfiguredAggroIcon(int style) {
        return switch (style) {
            case 1 -> ResourceLocation.parse((String)"aggroindicator:textures/alert_icon_1.png");
            case 2 -> ResourceLocation.parse((String)"aggroindicator:textures/alert_icon_2.png");
            default -> ResourceLocation.parse((String)"aggroindicator:textures/alert_icon_0.png");
        };
    }

    private static void _render(PoseStack matrix, double x, double y, float size, boolean isAboutToAttack, float[] colors) {
        RenderSystem.setShaderColor((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)aggroIcon);
        RenderSystem.enableBlend();
        Matrix4f m4f = matrix.last().pose();
        float halfWidth = size / 2.0f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(m4f, (float)((double)(-halfWidth) + x), (float)y, 0.25f).setUv(0.0f, 0.0f);
        buffer.addVertex(m4f, (float)((double)(-halfWidth) + x), (float)((double)size + y), 0.25f).setUv(0.0f, 1.0f);
        buffer.addVertex(m4f, (float)((double)halfWidth + x), (float)((double)size + y), 0.25f).setUv(1.0f, 1.0f);
        buffer.addVertex(m4f, (float)((double)halfWidth + x), (float)y, 0.25f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

