/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator.platform;

import io.github.raverbury.aggroindicator.Constants;
import io.github.raverbury.aggroindicator.platform.services.IConfigHelper;
import io.github.raverbury.aggroindicator.platform.services.INetworkHandler;
import io.github.raverbury.aggroindicator.platform.services.IPlatformHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final INetworkHandler NETWORK = Services.load(INetworkHandler.class);
    public static final IConfigHelper CONFIG_HELPER = Services.load(IConfigHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

