/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.config.ColorReferences;
import com.lowdragmc.shimmer.config.ColorReferencesTypeAdapter;
import com.lowdragmc.shimmer.config.ShimmerConfig;
import com.lowdragmc.shimmer.event.ShimmerLoadConfigEvent;
import com.lowdragmc.shimmer.platform.Services;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class Configuration {
    private static final String configurationFileName = "shimmer.json";
    private static final ResourceLocation configLocation = new ResourceLocation("shimmer", "shimmer.json");
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(ColorReferences.class, (Object)new ColorReferencesTypeAdapter()).setPrettyPrinting().create();
    public static final List<ShimmerConfig> configs = new ArrayList<ShimmerConfig>();
    public static ShimmerConfig auxiliaryConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        configs.clear();
        Object causedSource = "unknown";
        try {
            File[] fileArray;
            List resources = Minecraft.m_91087_().m_91098_().m_213829_(configLocation);
            for (Resource resource : resources) {
                causedSource = " file managed my minecraft located in [sourceName:" + resource.m_215506_() + ",location:" + resource.m_215506_() + "]";
                try (InputStreamReader reader = new InputStreamReader(resource.m_215507_());){
                    ShimmerConfig config = (ShimmerConfig)gson.fromJson((Reader)reader, ShimmerConfig.class);
                    if (!config.check((String)causedSource)) continue;
                    configs.add(config);
                }
            }
            for (String string : Services.PLATFORM.getLoadedMods()) {
                ShimmerConfig config;
                causedSource = " automatic configuration added by mod " + string;
                ResourceLocation candidateConfigurationPath = new ResourceLocation(string, configurationFileName);
                Optional<String> optionalConfiguration = Configuration.readConfiguration(candidateConfigurationPath);
                if (!optionalConfiguration.isPresent() || !(config = (ShimmerConfig)gson.fromJson(optionalConfiguration.get(), ShimmerConfig.class)).check((String)causedSource)) continue;
                configs.add(config);
                ShimmerConstants.LOGGER.info("automatic configuration added by mod:" + string + " path:" + candidateConfigurationPath);
            }
            for (Map.Entry entry : Services.PLATFORM.postLoadConfigurationEvent(new ShimmerLoadConfigEvent()).getConfiguration().entrySet()) {
                causedSource = " configuration added by mod " + (String)entry.getKey();
                ShimmerConfig config = (ShimmerConfig)gson.fromJson((String)entry.getValue(), ShimmerConfig.class);
                if (!config.check((String)causedSource)) continue;
                configs.add(config);
            }
            File shimmerConfigDir = Services.PLATFORM.getConfigDir().resolve("shimmer").toFile();
            if (!shimmerConfigDir.exists() || !shimmerConfigDir.isDirectory()) {
                shimmerConfigDir.mkdir();
            }
            for (File configFile : fileArray = Objects.requireNonNullElse(shimmerConfigDir.listFiles(), new File[0])) {
                if (!configFile.getName().endsWith(".json")) {
                    return;
                }
                causedSource = " file in config folder:" + configFile.getAbsolutePath();
                if (configFile.isDirectory()) continue;
                try (FileReader stream = new FileReader(configFile);){
                    ShimmerConfig config = (ShimmerConfig)gson.fromJson((Reader)stream, ShimmerConfig.class);
                    if (!config.check((String)causedSource)) continue;
                    if (config.enable.get()) {
                        configs.add(config);
                        continue;
                    }
                    ShimmerConstants.LOGGER.info("skip disabled config file from" + (String)causedSource);
                }
            }
            if (auxiliaryConfig != null) {
                configs.add(auxiliaryConfig);
            }
        }
        catch (IOException ioException) {
            ShimmerConstants.LOGGER.error("failed to get config resources, caused by " + (String)causedSource);
            ShimmerConstants.LOGGER.error(ioException.getMessage());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            ShimmerConstants.LOGGER.error("json syntax error in " + (String)causedSource);
            ShimmerConstants.LOGGER.error(jsonSyntaxException.getMessage());
        }
        catch (SecurityException e) {
            ShimmerConstants.LOGGER.error("has no permission to create shimmer config directory");
            ShimmerConstants.LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            ShimmerConstants.LOGGER.error("an un-expected exception happen while reloading config files, caused by" + (String)causedSource);
            ShimmerConstants.LOGGER.error(e.getMessage());
        }
        finally {
            ShimmerConstants.LOGGER.debug("reloading config files end");
        }
    }

    public static Optional<String> readConfiguration(ResourceLocation configurationPath) {
        return Minecraft.m_91087_().m_91098_().m_213713_(configurationPath).flatMap(resource -> {
            Optional<String> optional;
            block8: {
                BufferedReader reader = resource.m_215508_();
                try {
                    optional = Optional.of(reader.lines().collect(Collectors.joining()));
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioException) {
                        ShimmerConstants.LOGGER.error("find shimmer configuration file:" + configurationPath + " but failed to read", (Throwable)ioException);
                        return Optional.empty();
                    }
                }
                reader.close();
            }
            return optional;
        });
    }
}

