/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.utils.IOUtils;

public class FileUtility {
    public static final JsonParser jsonParser = new JsonParser();

    private FileUtility() {
    }

    public static String readInputStream(InputStream inputStream) throws IOException {
        byte[] streamData = IOUtils.toByteArray((InputStream)inputStream);
        return new String(streamData, StandardCharsets.UTF_8);
    }

    public static InputStream writeInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
    }

    public static JsonElement loadJson(File file) {
        try {
            if (!file.isFile()) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonElement json = jsonParser.parse(new JsonReader((Reader)reader));
            ((Reader)reader).close();
            return json;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void extractJarFiles(String resource, File targetPath, boolean replace) {
        try {
            InputStream inputstream;
            if ((!targetPath.exists() || replace) && (inputstream = FileUtility.class.getResourceAsStream(resource)) != null) {
                String content = FileUtility.readInputStream(inputstream);
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(targetPath), StandardCharsets.UTF_8);
                fileWriter.write(content);
                ((Writer)fileWriter).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

