/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer;

import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.platform.Services;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.http.util.Asserts;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S state, Property<T> property, String value) {
        Optional optionalT = property.m_6215_(value);
        if (optionalT.isPresent()) {
            return (S)((StateHolder)state.m_61124_(property, (Comparable)optionalT.get()));
        }
        ShimmerConstants.LOGGER.warn("Unable to read property: {} with value: {} for state", new Object[]{property.m_61708_(), value});
        return state;
    }

    @NotNull
    public static List<BlockState> getAvailableStates(Map<String, String> state, Block block) {
        StateDefinition stateDefinition = block.m_49965_();
        return stateDefinition.m_61056_().stream().filter(blockState -> {
            for (Map.Entry entry : state.entrySet()) {
                Comparable value = blockState.m_61143_(stateDefinition.m_61081_((String)entry.getKey()));
                if (value == null || Objects.equals(value.toString(), entry.getValue())) continue;
                return false;
            }
            return true;
        }).toList();
    }

    public static boolean checkBlockProperties(String configSource, Map<String, String> state, ResourceLocation blockLocation) {
        Block block = (Block)Registry.f_122824_.m_7745_(blockLocation);
        List<String> properties = block.m_49965_().m_61092_().stream().map(Property::m_61708_).toList();
        List<String> lack = state.keySet().stream().filter(key -> !properties.contains(key)).toList();
        if (!lack.isEmpty()) {
            ShimmerConstants.LOGGER.error("can't find one or more property for block " + blockLocation + " from" + configSource);
            lack.forEach(item -> ShimmerConstants.LOGGER.error("missing property " + item));
            properties.forEach(item -> ShimmerConstants.LOGGER.error("owning property " + item + "for block" + blockLocation));
            return true;
        }
        return false;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void RGBtoHSB(float[] rgb, float[] hsb) {
        float hue;
        int cmin;
        int b = (int)(rgb[2] * 255.0f);
        int r = (int)(rgb[0] * 255.0f);
        int g = (int)(rgb[1] * 255.0f);
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
    }

    public static int pack(float[] color) {
        Asserts.check((color.length == 3 ? 1 : 0) != 0, (String)"raw color array's length must be 3");
        return FastColor.ARGB32.m_13660_((int)255, (int)((int)(color[0] * 255.0f)), (int)((int)(color[1] * 255.0f)), (int)((int)(color[2] * 255.0f)));
    }

    public static boolean dumpAllLightingBlocks() {
        Stream<BlockState> states = Registry.f_122824_.m_123024_().flatMap(b -> b.m_49965_().m_61056_().stream()).filter(s -> s.m_60791_() > 0);
        File configDir = Services.PLATFORM.getConfigDir().resolve("shimmer").toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            ShimmerConstants.LOGGER.error("can't create config folder");
            return false;
        }
        File targetFile = new File(configDir, "LightBlocks.txt");
        try (FileWriter writer = new FileWriter(targetFile, false);){
            writer.write("=======================================\nAll blockStates with Light Emission > 0\nMaybe wrong, just for reference\");\n=======================================\n");
            writer.write("\n");
            states.forEach(s -> {
                String output = s.toString() + " -> " + s.m_60791_() + "\n";
                try {
                    writer.write(output);
                }
                catch (IOException e) {
                    ShimmerConstants.LOGGER.error("failed to write " + output);
                }
            });
        }
        catch (IOException e) {
            ShimmerConstants.LOGGER.error("failed to write block with light emission file");
            return false;
        }
        return true;
    }
}

