/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private static final Map<ResourceLocation, Boolean> cachedTexture = Maps.newHashMap();
    private static final Map<ResourceLocation, Boolean> cachedResources = Maps.newHashMap();

    public static boolean isTextureExist(ResourceLocation rs) {
        if (!cachedTexture.containsKey(rs)) {
            InputStream inputstream = ResourceUtils.class.getResourceAsStream(String.format("/assets/%s/textures/%s.png", rs.m_135827_(), rs.m_135815_()));
            if (inputstream == null) {
                cachedTexture.put(rs, false);
            } else {
                IOUtils.closeQuietly((InputStream)inputstream);
                cachedTexture.put(rs, true);
            }
        }
        return cachedTexture.get(rs);
    }

    public static boolean isResourceExist(ResourceLocation rs) {
        if (!cachedResources.containsKey(rs)) {
            InputStream inputstream = ResourceUtils.class.getResourceAsStream(String.format("/assets/%s/%s", rs.m_135827_(), rs.m_135815_()));
            if (inputstream == null) {
                cachedResources.put(rs, false);
            } else {
                IOUtils.closeQuietly((InputStream)inputstream);
                cachedResources.put(rs, true);
            }
        }
        return cachedResources.get(rs);
    }
}

