/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import com.lowdragmc.shimmer.Configuration;
import com.lowdragmc.shimmer.client.auxiliaryScreen.Eyedropper;
import com.lowdragmc.shimmer.client.auxiliaryScreen.HsbColorWidget;
import com.lowdragmc.shimmer.client.auxiliaryScreen.KeyType;
import com.lowdragmc.shimmer.client.auxiliaryScreen.PreviewWidget;
import com.lowdragmc.shimmer.client.auxiliaryScreen.SliderWidget;
import com.lowdragmc.shimmer.client.auxiliaryScreen.SuggestionEditBoxWidget;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.client.model.ShimmerMetadataSection;
import com.lowdragmc.shimmer.client.postprocessing.PostProcessing;
import com.lowdragmc.shimmer.config.BlockLight;
import com.lowdragmc.shimmer.config.Bloom;
import com.lowdragmc.shimmer.config.ItemLight;
import com.lowdragmc.shimmer.config.ShimmerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class AuxiliaryScreen
extends Screen {
    private HsbColorWidget colorPicker;
    private SuggestionEditBoxWidget inputText;
    private CycleButton<KeyType> mode;
    private SliderWidget radiusSlide;
    private PreviewWidget previewWidget;
    private Button applyButton;
    private Button exportButton;
    private Button addButton;
    private Button clearButton;
    private Button importColorButton;
    private SliderWidget colorHue;
    private SliderWidget colorSaturation;
    private SliderWidget colorBrightness;
    private SliderWidget colorR;
    private SliderWidget colorG;
    private SliderWidget colorB;
    private static final CycleButton.Builder<KeyType> cycleButtonBuilder = CycleButton.m_168894_(key -> Component.m_237113_((String)key.toString().toLowerCase())).m_168948_((Object)KeyType.DEFAULT).m_232502_(KeyType.VALUES);

    public AuxiliaryScreen() {
        super((Component)Component.m_237113_((String)"AuxiliaryScreen"));
    }

    protected void m_7856_() {
        Objects.requireNonNull(this.f_96541_).f_91068_.m_90926_(true);
        this.colorPicker = new HsbColorWidget(20, 20, 100, 80, 20, 10, (Component)Component.m_237113_((String)"1"));
        this.inputText = new SuggestionEditBoxWidget(this.f_96541_.f_91062_, 220, 20, 200, 20, (Component)Component.m_237113_((String)"s"));
        this.radiusSlide = new SliderWidget(20, 110, 150, 20, 1.0, 15.0, 0.2, Component.m_237113_((String)"Radius"), "%.2f", 10.0);
        this.mode = cycleButtonBuilder.m_168936_(20, 130, 150, 20, (Component)Component.m_237113_((String)"select mode"), (button, value) -> {
            this.inputText.onModeChange((KeyType)((Object)value));
            this.previewWidget.onModeChange((KeyType)((Object)value));
        });
        this.previewWidget = new PreviewWidget(20, 160, 90, 90, (Component)Component.m_237113_((String)"preview"));
        this.inputText.addCompleteListener(this.previewWidget::onContentNeedChange);
        this.inputText.addCandidateListener(this.previewWidget::onCandicateChange);
        this.m_142416_((GuiEventListener)this.colorPicker);
        this.m_142416_((GuiEventListener)this.inputText);
        this.m_142416_((GuiEventListener)this.mode);
        this.m_142416_((GuiEventListener)this.previewWidget);
        this.m_142416_((GuiEventListener)this.radiusSlide);
        this.applyButton = new Button(220, 50, 45, 20, (Component)Component.m_237113_((String)"apply"), button -> {
            Configuration.load();
            LightManager.INSTANCE.loadConfig();
            PostProcessing.loadConfig();
            ShimmerMetadataSection.onResourceManagerReload();
            LightManager.onResourceManagerReload();
            for (PostProcessing postProcessing : PostProcessing.values()) {
                postProcessing.m_6213_(this.f_96541_.m_91098_());
            }
            this.f_96541_.m_6937_(() -> ((LevelRenderer)this.f_96541_.f_91060_).m_109818_());
        });
        this.addButton = new Button(270, 50, 45, 20, (Component)Component.m_237113_((String)"add"), button -> {
            ShimmerConfig config;
            if (!this.inputText.isComplete) {
                return;
            }
            if (Configuration.auxiliaryConfig != null) {
                config = Configuration.auxiliaryConfig;
            } else {
                config = new ShimmerConfig();
                config.configSource = "AuxiliaryScreen";
                config.init();
                config.enable = new AtomicBoolean(true);
                Configuration.auxiliaryConfig = config;
            }
            int rgb = this.colorPicker.rgb();
            float radius = (float)this.radiusSlide.actualValue;
            String content = this.inputText.m_94155_();
            switch ((KeyType)((Object)((Object)this.mode.m_168883_()))) {
                case COLORED_BLOCK: {
                    BlockLight light = new BlockLight();
                    light.setRGB(rgb);
                    light.radius = radius;
                    light.blockName = content;
                    config.blockLights.add(light);
                    break;
                }
                case LIGHT_ITEM: {
                    ItemLight light = new ItemLight();
                    light.setRGB(rgb);
                    light.radius = radius;
                    light.itemName = content;
                    config.itemLights.add(light);
                    break;
                }
                case BLOOM_PARTICLE: {
                    Bloom bloom = new Bloom();
                    bloom.particleName = content;
                    config.blooms.add(bloom);
                    break;
                }
                case BLOOM_FLUID: {
                    Bloom bloom = new Bloom();
                    bloom.fluidName = content;
                    config.blooms.add(bloom);
                    break;
                }
                case BLOOM_BLOCK: {
                    Bloom bloom = new Bloom();
                    bloom.blockName = content;
                    config.blooms.add(bloom);
                }
            }
        });
        this.exportButton = new Button(320, 50, 45, 20, (Component)Component.m_237113_((String)"export"), button -> {
            if (Configuration.auxiliaryConfig != null) {
                String json = Configuration.gson.toJson((Object)Configuration.auxiliaryConfig);
                TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)json);
            } else {
                TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)" ");
            }
        });
        this.clearButton = new Button(370, 50, 45, 20, (Component)Component.m_237113_((String)"clear"), button -> {
            Configuration.auxiliaryConfig = null;
        });
        this.m_142416_((GuiEventListener)this.applyButton);
        this.m_142416_((GuiEventListener)this.addButton);
        this.m_142416_((GuiEventListener)this.exportButton);
        this.m_142416_((GuiEventListener)this.clearButton);
        this.importColorButton = new Button(220, 80, 95, 20, (Component)Component.m_237113_((String)"import color"), button -> {
            if (Eyedropper.isDataAvailable()) {
                this.colorPicker.setRGB(Eyedropper.getEyedropperColor());
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"set record color"));
            } else if (Eyedropper.getState()) {
                this.colorPicker.setRGB(Eyedropper.getCurrentColor());
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"no record, use current"));
            } else {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"not under eyedropper mode, can't import color"));
            }
        });
        this.m_142416_((GuiEventListener)this.importColorButton);
        this.colorHue = new SliderWidget(220, 110, 200, 20, 0.0, 360.0, 1.0, Component.m_237113_((String)"Hue"), "%d", 204.0);
        this.colorSaturation = new SliderWidget(220, 130, 200, 20, 0.0, 100.0, 1.0, Component.m_237113_((String)"Saturation"), "%d%%", 72.0);
        this.colorBrightness = new SliderWidget(220, 150, 200, 20, 0.0, 100.0, 1.0, Component.m_237113_((String)"Brightness"), "%d%%", 94.0);
        this.colorR = new SliderWidget(220, 170, 200, 20, 0.0, 255.0, 1.0, Component.m_237113_((String)"R"), "%d", 67.0);
        this.colorG = new SliderWidget(220, 190, 200, 20, 0.0, 255.0, 1.0, Component.m_237113_((String)"G"), "%d", 170.0);
        this.colorB = new SliderWidget(220, 210, 200, 20, 0.0, 255.0, 1.0, Component.m_237113_((String)"B"), "%d", 239.0);
        this.m_142416_((GuiEventListener)this.colorHue);
        this.m_142416_((GuiEventListener)this.colorSaturation);
        this.m_142416_((GuiEventListener)this.colorBrightness);
        this.m_142416_((GuiEventListener)this.colorR);
        this.m_142416_((GuiEventListener)this.colorG);
        this.m_142416_((GuiEventListener)this.colorB);
        this.colorHue.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getHSB();
            color[0] = (float)newValue;
            this.colorPicker.setHSB(color);
        });
        this.colorSaturation.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getHSB();
            color[1] = (float)(newValue / 100.0);
            this.colorPicker.setHSB(color);
        });
        this.colorBrightness.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getHSB();
            color[2] = (float)(newValue / 100.0);
            this.colorPicker.setHSB(color);
        });
        this.colorR.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getRGB();
            color[0] = (float)(newValue / 255.0);
            this.colorPicker.setRGB(color);
        });
        this.colorG.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getRGB();
            color[1] = (float)(newValue / 255.0);
            this.colorPicker.setRGB(color);
        });
        this.colorB.addListener((oldValue, newValue) -> {
            float[] color = this.colorPicker.getRGB();
            color[2] = (float)(newValue / 255.0);
            this.colorPicker.setRGB(color);
        });
        this.colorPicker.registerListener(() -> {
            float[] hsb = this.colorPicker.getHSB();
            this.colorHue.trySetValue(hsb[0], false);
            this.colorSaturation.trySetValue(hsb[1] * 100.0f, false);
            this.colorBrightness.trySetValue(hsb[2] * 100.0f, false);
            float[] rgb = this.colorPicker.getRGB();
            this.colorR.trySetValue(rgb[0] * 255.0f, false);
            this.colorG.trySetValue(rgb[1] * 255.0f, false);
            this.colorB.trySetValue(rgb[2] * 255.0f, false);
        });
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.f_96541_ = minecraft;
        this.f_96542_ = minecraft.m_91291_();
        this.f_96547_ = minecraft.f_91062_;
        this.f_96543_ = width;
        this.f_96544_ = height;
    }

    public void m_7861_() {
        Objects.requireNonNull(this.f_96541_).f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.m_7222_() == null) {
            if (this.colorHue.m_198029_()) {
                return this.colorHue.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.colorSaturation.m_198029_()) {
                return this.colorSaturation.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.colorBrightness.m_198029_()) {
                return this.colorBrightness.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.colorR.m_198029_()) {
                return this.colorR.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.colorG.m_198029_()) {
                return this.colorG.m_7933_(keyCode, scanCode, modifiers);
            }
            if (this.radiusSlide.m_198029_()) {
                return this.radiusSlide.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86600_() {
        boolean buttonVisible;
        this.inputText.m_94120_();
        this.addButton.f_93624_ = buttonVisible = (this.inputText.isComplete || StringUtils.isBlank((CharSequence)this.inputText.m_94155_())) && !this.inputText.m_93696_();
        this.exportButton.f_93624_ = buttonVisible;
        this.clearButton.f_93624_ = buttonVisible;
        this.applyButton.f_93624_ = buttonVisible;
        this.importColorButton.f_93624_ = buttonVisible;
        this.colorHue.f_93624_ = buttonVisible;
        this.colorSaturation.f_93624_ = buttonVisible;
        this.colorBrightness.f_93624_ = buttonVisible;
        this.colorR.f_93624_ = buttonVisible;
        this.colorG.f_93624_ = buttonVisible;
        this.colorB.f_93624_ = buttonVisible;
    }
}

