/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.Utils;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.lowdragmc.shimmer.client.shader.ShaderSSBO;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Eyedropper {
    ShaderStorageBufferObject{
        public static ShaderSSBO ssbo;
        public static ShaderInstance colorPickShader;
        public static RenderTarget flipTarget;
        private static final int bindingIndex = 5;

        @Override
        public void updateCurrentColor() {
            Window window = Minecraft.m_91087_().m_91268_();
            RenderSystem.m_187554_();
            this.updateFlipTarget();
            RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
            RenderUtils.warpGLDebugLabel("blit_move", () -> RenderUtils.fastBlit(mainRenderTarget, flipTarget));
            RenderUtils.warpGLDebugLabel("blit_back", () -> {
                ssbo.bindBuffer();
                GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.m_84507_();
                GlStateManager.m_84298_((boolean)false);
                mainRenderTarget.m_83947_(true);
                colorPickShader.m_173350_("DiffuseSampler", (Object)flipTarget.m_83975_());
                colorPickShader.m_173363_();
                1.colorPickShader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
                GlStateManager.m_84525_();
                RenderSystem.m_69453_();
                Tesselator tesselator = RenderSystem.m_69883_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                bufferbuilder.m_5483_(-1.0, 1.0, 0.0).m_5752_();
                bufferbuilder.m_5483_(-1.0, -1.0, 0.0).m_5752_();
                bufferbuilder.m_5483_(1.0, -1.0, 0.0).m_5752_();
                bufferbuilder.m_5483_(1.0, 1.0, 0.0).m_5752_();
                BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                colorPickShader.m_173362_();
                GlStateManager.m_84298_((boolean)true);
                GlStateManager.m_84300_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.m_84513_();
                ssbo.unBindBuffer();
            });
            ssbo.getSubData(0L, currentColor);
        }

        @Override
        public void setShader(ShaderInstance shader) {
            colorPickShader = shader;
        }

        private void updateFlipTarget() {
            Window window = Minecraft.m_91087_().m_91268_();
            if (1.flipTarget.f_83915_ != window.m_85441_() || 1.flipTarget.f_83916_ != window.m_85442_()) {
                flipTarget.m_83941_(window.m_85441_(), window.m_85442_(), Minecraft.f_91002_);
            }
        }

        @Override
        public void init() {
            ssbo = new ShaderSSBO();
            ssbo.createBufferData(32L, 35049);
            Objects.requireNonNull(colorPickShader, "colorPickShader should never be null");
            ssbo.bindToShader(colorPickShader.m_108943_(), 0, 5);
            ssbo.bindIndex(5);
            flipTarget = new RenderTarget(false){};
            this.updateFlipTarget();
        }

        @Override
        public void destroy() {
            if (flipTarget != null) {
                flipTarget.m_83930_();
                flipTarget = null;
            }
            if (ssbo != null) {
                ssbo.close();
                ssbo = null;
            }
        }

        @Override
        public String modeName() {
            return "ShaderStorageBufferObject";
        }
    }
    ,
    DOWNLOAD{
        private static NativeImage nativeImage;
        private static int lastWidth;
        private static int lastHeight;
        private static int openCount;
        private static int closeCount;

        @Override
        public void updateCurrentColor() {
            RenderTarget renderTarget = Minecraft.m_91087_().m_91385_();
            if (lastWidth != renderTarget.f_83915_ || lastHeight != renderTarget.f_83916_) {
                if (nativeImage != null) {
                    nativeImage.close();
                    ++closeCount;
                }
                nativeImage = new NativeImage(renderTarget.f_83915_, renderTarget.f_83916_, false);
                ++openCount;
                lastWidth = renderTarget.f_83915_;
                lastHeight = renderTarget.f_83916_;
            }
            RenderSystem.m_69396_((int)renderTarget.m_83975_());
            nativeImage.m_85045_(0, true);
            nativeImage.m_85122_();
            Window window = Minecraft.m_91087_().m_91268_();
            int rgba = nativeImage.m_84985_(window.m_85441_() / 2, window.m_85442_() / 2);
            Eyedropper.currentColor[0] = (float)NativeImage.m_85085_((int)rgba) / 255.0f;
            Eyedropper.currentColor[1] = (float)NativeImage.m_85103_((int)rgba) / 255.0f;
            Eyedropper.currentColor[2] = (float)NativeImage.m_85119_((int)rgba) / 255.0f;
            if (Math.abs(closeCount - openCount) >= 5) {
                throw new RuntimeException();
            }
        }

        @Override
        public void setShader(ShaderInstance shader) {
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
            if (nativeImage != null) {
                nativeImage.close();
                nativeImage = null;
                ++closeCount;
            }
            lastWidth = -1;
            lastHeight = -1;
        }

        @Override
        public String modeName() {
            return "glGetTexImage";
        }

        static {
            openCount = 0;
            closeCount = 0;
        }
    };

    private static boolean dataAvailable;
    private static final float[] eyedropperColor;
    private static float[] currentColor;
    public static Eyedropper mode;
    private static boolean enable;
    private static boolean readyForRecord;
    private static final String colorPreviewChar;

    private static Component makeColorPreview(float[] color) {
        return Component.m_237113_((String)colorPreviewChar).m_130938_(style -> style.m_178520_(Utils.pack(color)));
    }

    protected abstract void updateCurrentColor();

    public static void update(PoseStack matrixStack) {
        if (enable) {
            mode.updateCurrentColor();
            mode.renderIndicator(matrixStack);
            if (ShimmerConstants.recordScreenColor.m_90857_() && readyForRecord) {
                Eyedropper.eyedropperColor[0] = currentColor[0];
                Eyedropper.eyedropperColor[1] = currentColor[1];
                Eyedropper.eyedropperColor[2] = currentColor[2];
                dataAvailable = true;
                readyForRecord = false;
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("set color " + Eyedropper.formatRGB(eyedropperColor))).m_7220_(Eyedropper.makeColorPreview(eyedropperColor)));
            } else if (!ShimmerConstants.recordScreenColor.m_90857_()) {
                readyForRecord = true;
            }
        }
    }

    private static String formatRGB(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        StringBuilder str = new StringBuilder();
        str.append("r:").append(r);
        do {
            str.append(' ');
        } while (str.length() != 6);
        str.append("g:").append(g);
        do {
            str.append(' ');
        } while (str.length() != 12);
        str.append("b:").append(b);
        do {
            str.append(' ');
        } while (str.length() != 18);
        return str.toString();
    }

    private void renderIndicator(PoseStack poseStack) {
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        int centerX = (int)((double)((float)window.m_85441_() / 2.0f) / scale);
        int centerY = (int)((double)((float)window.m_85442_() / 2.0f) / scale);
        int backWidth = 1;
        RenderUtils.warpGLDebugLabel("draw_back", () -> GuiComponent.m_93172_((PoseStack)poseStack, (int)(centerX + 10 - backWidth), (int)(centerY + 10 - backWidth), (int)(centerX + 30 + backWidth), (int)(centerY + 10 + 20 + backWidth), (int)Integer.MAX_VALUE));
        RenderUtils.warpGLDebugLabel("draw_current_color_block", () -> GuiComponent.m_93172_((PoseStack)poseStack, (int)(centerX + 10), (int)(centerY + 10), (int)(centerX + 30), (int)(centerY + 10 + 20), (int)Utils.pack(currentColor)));
        if (dataAvailable) {
            RenderUtils.warpGLDebugLabel("draw_selected_color_block", () -> GuiComponent.m_93172_((PoseStack)poseStack, (int)(centerX + 10 + 10), (int)(centerY + 10), (int)(centerX + 30), (int)(centerY + 10 + 20), (int)Utils.pack(eyedropperColor)));
        }
    }

    public abstract void setShader(ShaderInstance var1);

    public abstract String modeName();

    protected abstract void init();

    protected abstract void destroy();

    public static Pair<ShaderInstance, Consumer<ShaderInstance>> registerShaders(ResourceManager resourceManager) {
        try {
            return Pair.of((Object)new ShaderInstance((ResourceProvider)resourceManager, new ResourceLocation("shimmer", "pick_color").toString(), DefaultVertexFormat.f_85814_), mode::setShader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void switchState() {
        RenderSystem.m_69879_(() -> {
            if (enable) {
                mode.destroy();
                dataAvailable = false;
                enable = false;
            } else {
                mode.init();
                enable = true;
            }
        });
    }

    public static boolean getState() {
        return enable;
    }

    public static void switchMode(Eyedropper newMode) {
        RenderSystem.m_69879_(() -> {
            if (newMode == mode) {
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("already in " + mode.modeName())));
                return;
            }
            boolean isEnable = enable;
            if (isEnable) {
                Eyedropper.switchState();
            }
            switch (newMode) {
                case ShaderStorageBufferObject: {
                    DOWNLOAD.destroy();
                    break;
                }
                case DOWNLOAD: {
                    ShaderStorageBufferObject.destroy();
                }
            }
            mode = newMode;
            if (isEnable) {
                Eyedropper.switchState();
            }
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("switch to " + mode.modeName())));
        });
    }

    public static boolean isDataAvailable() {
        return dataAvailable;
    }

    public static float[] getCurrentColor() {
        if (enable) {
            return Arrays.copyOf(currentColor, 3);
        }
        throw new RuntimeException("can't get current when eyedropper mode is disabled");
    }

    public static float[] getEyedropperColor() {
        if (dataAvailable) {
            return Arrays.copyOf(eyedropperColor, 3);
        }
        throw new RuntimeException("can't get eyedropper color while data is unavailable");
    }

    static {
        dataAvailable = false;
        eyedropperColor = new float[3];
        currentColor = new float[3];
        mode = ShaderSSBO.support() ? ShaderStorageBufferObject : DOWNLOAD;
        enable = false;
        readyForRecord = true;
        colorPreviewChar = (String)Util.m_137537_(() -> {
            Object holder = "\u2b1b";
            if (Services.PLATFORM.isModLoaded("modernui")) {
                holder = "\u200c" + (String)holder + "\u200c";
            }
            return holder;
        });
    }
}

