/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import com.google.common.collect.ImmutableMap;
import com.lowdragmc.shimmer.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.FastColor;

public class HsbColorWidget
extends AbstractWidget {
    public static ShaderInstance hsbShader;
    private static final VertexFormatElement HSB_Alpha;
    public static final VertexFormat HSB_VERTEX_FORMAT;
    private int gap;
    private int barWidth;
    private float h = 204.0f;
    private float s = 0.72f;
    private float b = 0.94f;
    private int alpha = 1;
    private int rgb;
    private HSB_MODE mode = HSB_MODE.H;
    private List<Runnable> listeners = new ArrayList<Runnable>();

    public HsbColorWidget(int x, int y, int width, int height, int gap, int barWidth, Component arg) {
        super(x, y, width, height, arg);
        this.gap = gap;
        this.barWidth = barWidth;
        this.refreshRGB(true);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        this.drawHsbContext(pose, builder);
        this.renderInfo(poseStack, builder);
    }

    private void drawHsbContext(Matrix4f pose, BufferBuilder builder) {
        RenderSystem.m_157427_(() -> hsbShader);
        builder.m_166779_(VertexFormat.Mode.QUADS, HSB_VERTEX_FORMAT);
        this.renderMain(pose, builder);
        this.renderSlide(pose, builder);
        this.renderColor(pose, builder);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    private void renderMain(Matrix4f pose, BufferBuilder builder) {
        float _h = 0.0f;
        float _s = 0.0f;
        float _b = 0.0f;
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 0.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = 0.0f;
                _s = this.s;
                _b = 1.0f;
                break;
            }
            case B: {
                _h = 0.0f;
                _s = 1.0f;
                _b = this.b;
            }
        }
        builder.m_85982_(pose, (float)this.f_93620_, (float)this.f_93621_, 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 0.0f;
                _b = 0.0f;
                break;
            }
            case S: {
                _h = 0.0f;
                _s = this.s;
                _b = 0.0f;
                break;
            }
            case B: {
                _h = 0.0f;
                _s = 0.0f;
                _b = this.b;
            }
        }
        builder.m_85982_(pose, (float)this.f_93620_, (float)(this.f_93621_ + this.f_93619_), 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 1.0f;
                _b = 0.0f;
                break;
            }
            case S: {
                _h = 360.0f;
                _s = this.s;
                _b = 0.0f;
                break;
            }
            case B: {
                _h = 360.0f;
                _s = 0.0f;
                _b = this.b;
            }
        }
        builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)(this.f_93621_ + this.f_93619_), 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        switch (this.mode) {
            case H: {
                _h = this.h;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = 360.0f;
                _s = this.s;
                _b = 1.0f;
                break;
            }
            case B: {
                _h = 360.0f;
                _s = 1.0f;
                _b = this.b;
            }
        }
        builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)this.f_93621_, 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
    }

    private void renderSlide(Matrix4f pose, BufferBuilder builder) {
        float _h = 0.0f;
        float _s = 0.0f;
        float _b = 0.0f;
        int barX = this.f_93620_ + this.f_93618_ + this.gap;
        switch (this.mode) {
            case H: {
                _h = 0.0f;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = this.h;
                _s = 0.0f;
                _b = this.b;
                break;
            }
            case B: {
                _h = this.h;
                _s = this.s;
                _b = 0.0f;
            }
        }
        builder.m_85982_(pose, (float)barX, (float)(this.f_93621_ + this.f_93619_), 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        builder.m_85982_(pose, (float)(barX + this.barWidth), (float)(this.f_93621_ + this.f_93619_), 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        switch (this.mode) {
            case H: {
                _h = 360.0f;
                _s = 1.0f;
                _b = 1.0f;
                break;
            }
            case S: {
                _h = this.h;
                _s = 1.0f;
                _b = this.b;
                break;
            }
            case B: {
                _h = this.h;
                _s = this.s;
                _b = 1.0f;
            }
        }
        builder.m_85982_(pose, (float)(barX + this.barWidth), (float)this.f_93621_, 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
        builder.m_85982_(pose, (float)barX, (float)this.f_93621_, 0.0f);
        this.putColor(builder, _h, _s, _b, this.alpha).m_5751_();
        builder.m_5752_();
    }

    private void renderInfo(PoseStack poseStack, BufferBuilder builder) {
        Font font = Minecraft.m_91087_().f_91062_;
        int strX = this.f_93620_ + this.f_93618_ + this.gap + this.barWidth + 10;
        float f = this.f_93619_;
        Objects.requireNonNull(font);
        int n = (int)Math.max(0.0f, (f - 6.0f * 9.0f) / 5.0f);
        Objects.requireNonNull(font);
        int strGapY = n + 9;
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("h:" + (int)this.h + "\u00b0"), (int)strX, (int)this.f_93621_, (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("s:" + (int)(this.s * 100.0f) + "%"), (int)strX, (int)(this.f_93621_ + strGapY), (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("b:" + (int)(this.b * 100.0f) + "%"), (int)strX, (int)(this.f_93621_ + strGapY * 2), (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("r:" + (this.rgb >> 16 & 0xFF)), (int)strX, (int)(this.f_93621_ + strGapY * 3), (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("g:" + (this.rgb >> 8 & 0xFF)), (int)strX, (int)(this.f_93621_ + strGapY * 4), (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("b:" + (this.rgb & 0xFF)), (int)strX, (int)(this.f_93621_ + strGapY * 5), (int)-1);
        HsbColorWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)("mode:" + this.mode), (int)strX, (int)(this.f_93621_ + strGapY * 6), (int)-1);
    }

    private void renderColor(Matrix4f pose, BufferBuilder builder) {
        int colorX = this.f_93620_ + this.f_93618_ + this.gap + this.barWidth + 10 + 30;
        int colorSideLength = 20;
        builder.m_85982_(pose, (float)colorX, (float)this.f_93621_, 0.0f);
        this.putColor(builder, this.h, this.s, this.b, this.alpha).m_5751_();
        builder.m_5752_();
        builder.m_85982_(pose, (float)colorX, (float)(this.f_93621_ + colorSideLength), 0.0f);
        this.putColor(builder, this.h, this.s, this.b, this.alpha).m_5751_();
        builder.m_5752_();
        builder.m_85982_(pose, (float)(colorX + colorSideLength), (float)(this.f_93621_ + colorSideLength), 0.0f);
        this.putColor(builder, this.h, this.s, this.b, this.alpha).m_5751_();
        builder.m_5752_();
        builder.m_85982_(pose, (float)(colorX + colorSideLength), (float)this.f_93621_, 0.0f);
        this.putColor(builder, this.h, this.s, this.b, this.alpha).m_5751_();
        builder.m_5752_();
    }

    private BufferBuilder putColor(BufferBuilder builder, float h, float s, float b, float alpha) {
        builder.m_5832_(0, h);
        builder.m_5832_(4, s);
        builder.m_5832_(8, b);
        builder.m_5832_(12, alpha);
        return builder;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_) && (mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) || mouseX >= (double)this.f_93620_ + (double)this.f_93618_ + (double)this.gap && mouseX <= (double)(this.f_93620_ + this.f_93618_ + this.gap + this.barWidth));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.mode = switch (this.mode) {
                default -> throw new IncompatibleClassChangeError();
                case HSB_MODE.H -> HSB_MODE.S;
                case HSB_MODE.S -> HSB_MODE.B;
                case HSB_MODE.B -> HSB_MODE.H;
            };
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void refreshRGB(boolean trigListener) {
        this.rgb = Utils.HSBtoRGB(this.h / 360.0f, this.s, this.b);
        if (trigListener) {
            this.listeners.forEach(Runnable::run);
        }
    }

    private static float normalizeMouse(double mouse, int pos, int size) {
        double x = mouse - (double)pos;
        double y = x % (double)size / (double)size;
        if (y < 0.0) {
            x = -x;
            y = -y;
        }
        return (float)((x /= (double)size) % 2.0 > 1.0 ? 1.0 - y : y);
    }

    public void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        float normalizedX = HsbColorWidget.normalizeMouse(mouseX, this.f_93620_, this.f_93618_);
        boolean isBar = mouseX - (double)this.f_93620_ > (double)this.f_93618_;
        float normalizedY = HsbColorWidget.normalizeMouse(mouseY, this.f_93621_, this.f_93619_);
        switch (this.mode) {
            case H: {
                if (isBar) {
                    this.h = (1.0f - normalizedY) * 360.0f;
                    break;
                }
                this.s = normalizedX;
                this.b = 1.0f - normalizedY;
                break;
            }
            case S: {
                if (isBar) {
                    this.s = 1.0f - normalizedY;
                    break;
                }
                this.h = normalizedX * 360.0f;
                this.b = 1.0f - normalizedY;
                break;
            }
            case B: {
                if (isBar) {
                    this.b = 1.0f - normalizedY;
                    break;
                }
                this.h = normalizedX * 360.0f;
                this.s = normalizedY;
            }
        }
        this.refreshRGB(true);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public float[] getHSB() {
        return new float[]{this.h, this.s, this.b};
    }

    public float[] getRGB() {
        return new float[]{(float)FastColor.ARGB32.m_13665_((int)this.rgb) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)this.rgb) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)this.rgb) / 255.0f};
    }

    public void setHSB(float[] hsb) {
        if (hsb[0] != this.h || hsb[1] != this.s || hsb[2] != this.b) {
            this.h = hsb[0];
            this.s = hsb[1];
            this.b = hsb[2];
            this.refreshRGB(true);
        }
    }

    public void setRGB(float[] rgb) {
        float[] hsb = new float[3];
        Utils.RGBtoHSB(rgb, hsb);
        hsb[0] = hsb[0] * 360.0f;
        this.setHSB(hsb);
    }

    public int rgb() {
        return this.rgb;
    }

    public void registerListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public static Pair<ShaderInstance, Consumer<ShaderInstance>> registerShaders(ResourceManager resourceManager) {
        try {
            return Pair.of((Object)new ShaderInstance((ResourceProvider)resourceManager, new ResourceLocation("shimmer", "hsb_block").toString(), HSB_VERTEX_FORMAT), shaderInstance -> {
                hsbShader = shaderInstance;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HSB_Alpha = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.COLOR, 4);
        HSB_VERTEX_FORMAT = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"HSB_ALPHA", (Object)HSB_Alpha).build());
    }

    private static enum HSB_MODE {
        H("hue"),
        S("saturation"),
        B("brightness");

        private final String name;

        private HSB_MODE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

