/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import com.lowdragmc.shimmer.client.auxiliaryScreen.KeyType;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

@ParametersAreNonnullByDefault
public class PreviewWidget
extends AbstractWidget {
    private KeyType type;
    private ResourceLocation resourceLocation;
    private final float scale = 5.0f;

    public PreviewWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public void onModeChange(KeyType type) {
        this.type = type;
        this.resourceLocation = null;
    }

    public void onContentNeedChange(KeyType type, ResourceLocation content) {
        this.type = type;
        this.resourceLocation = content;
    }

    public void onCandicateChange(KeyType type, ResourceLocation candicate) {
        this.type = type;
        this.resourceLocation = candicate;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.type != null && this.resourceLocation != null) {
            switch (this.type) {
                case COLORED_BLOCK: 
                case BLOOM_BLOCK: {
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    Block block = (Block)Registry.f_122824_.m_7745_(this.resourceLocation);
                    PoseStack modelViewStack = RenderSystem.m_157191_();
                    modelViewStack.m_85836_();
                    modelViewStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
                    modelViewStack.m_85841_(5.0f, 5.0f, 1.0f);
                    itemRenderer.m_115203_(new ItemStack((ItemLike)block), 0, 0);
                    modelViewStack.m_85849_();
                    RenderSystem.m_157182_();
                    break;
                }
                case LIGHT_ITEM: {
                    ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                    Item item = (Item)Registry.f_122827_.m_7745_(this.resourceLocation);
                    PoseStack modelViewStack = RenderSystem.m_157191_();
                    modelViewStack.m_85836_();
                    modelViewStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
                    modelViewStack.m_85841_(5.0f, 5.0f, 1.0f);
                    itemRenderer.m_115203_(new ItemStack((ItemLike)item), 0, 0);
                    modelViewStack.m_85849_();
                    RenderSystem.m_157182_();
                    break;
                }
                case BLOOM_PARTICLE: {
                    TextureAtlas textureAtlas = Minecraft.m_91087_().f_91061_.f_107296_;
                    TextureAtlasSprite sprite = textureAtlas.m_118316_(new ResourceLocation(this.resourceLocation.m_135827_(), "particle/" + this.resourceLocation.m_135815_()));
                    if (Objects.equals(sprite.m_118413_(), MissingTextureAtlasSprite.m_118071_())) {
                        return;
                    }
                    Matrix4f pose = poseStack.m_85850_().m_85861_();
                    RenderSystem.m_157179_((int)0, (ResourceLocation)TextureAtlas.f_118260_);
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                    builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    builder.m_85982_(pose, (float)this.f_93620_, (float)this.f_93621_, 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
                    builder.m_85982_(pose, (float)this.f_93620_, (float)(this.f_93621_ + this.f_93619_), 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
                    builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)(this.f_93621_ + this.f_93619_), 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
                    builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)this.f_93621_, 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
                    BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)builder.m_231175_());
                    break;
                }
                case BLOOM_FLUID: {
                    Matrix4f pose = poseStack.m_85850_().m_85861_();
                    RenderSystem.m_157179_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                    RenderSystem.m_157427_(GameRenderer::m_172820_);
                    BufferBuilder builder = Tesselator.m_85913_().m_85915_();
                    builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    Function atlas = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
                    Fluid fluid = (Fluid)Registry.f_122822_.m_7745_(this.resourceLocation);
                    TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(Services.PLATFORM.getFluidTextureLocation(fluid, true));
                    int fluidColor = Services.PLATFORM.getFluidColor(fluid);
                    builder.m_85982_(pose, (float)this.f_93620_, (float)this.f_93621_, 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_193479_(fluidColor).m_5752_();
                    builder.m_85982_(pose, (float)this.f_93620_, (float)(this.f_93621_ + this.f_93619_), 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_193479_(fluidColor).m_5752_();
                    builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)(this.f_93621_ + this.f_93619_), 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_193479_(fluidColor).m_5752_();
                    builder.m_85982_(pose, (float)(this.f_93620_ + this.f_93618_), (float)this.f_93621_, 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_193479_(fluidColor).m_5752_();
                    BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)builder.m_231175_());
                }
            }
        }
    }
}

