/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.http.util.Asserts;
import org.lwjgl.glfw.GLFW;

public class SliderWidget
extends AbstractSliderButton {
    protected final double minValue;
    protected final double maxValue;
    protected final double stepSize;
    protected double actualValue;
    protected final MutableComponent prefixMessage;
    protected final String formatStr;
    protected final List<SliderListener> listeners = new ArrayList<SliderListener>();

    public SliderWidget(int x, int y, int width, int height, double minValue, double maxValue, double stepSize, MutableComponent prefixMessage, String formatStr, double initialValue) {
        super(x, y, width, height, (Component)prefixMessage, initialValue);
        Asserts.check((stepSize != 0.0 ? 1 : 0) != 0, (String)"step for slider widget can't be zero");
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = stepSize;
        this.prefixMessage = prefixMessage;
        this.formatStr = formatStr;
        this.f_93577_ = initialValue / (maxValue - minValue);
        this.actualValue = initialValue;
        this.m_5697_();
        this.m_5695_();
    }

    protected void m_5695_() {
        if (this.formatStr.contains("%d")) {
            this.m_93666_((Component)this.prefixMessage.m_6881_().m_7220_((Component)Component.m_237113_((String)(":" + String.format(this.formatStr, (int)this.actualValue)))));
        } else {
            this.m_93666_((Component)this.prefixMessage.m_6881_().m_7220_((Component)Component.m_237113_((String)(":" + String.format(this.formatStr, this.actualValue)))));
        }
    }

    protected void m_5697_() {
        this.applyValueInner(true);
    }

    private void applyValueInner(boolean trigListener) {
        double newValue = this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
        double candidateValue = (double)((int)(newValue / this.stepSize)) * this.stepSize;
        double candidateValue2 = candidateValue + this.stepSize;
        double oldActualValue = this.actualValue;
        this.actualValue = Math.abs(newValue - candidateValue2) > Math.abs(newValue - candidateValue) ? candidateValue : candidateValue2;
        if (trigListener) {
            this.listeners.forEach(listener -> listener.accept(oldActualValue, this.actualValue));
        }
        this.m_5695_();
    }

    public void trySetValue(double value, boolean trigListener) {
        double newValue;
        double percent = (value - this.minValue) / (this.maxValue - this.minValue);
        double d = percent >= 0.0 ? (percent <= 1.0 ? percent : 1.0) : (newValue = 0.0);
        if (newValue != this.f_93577_) {
            this.f_93577_ = newValue;
            this.applyValueInner(trigListener);
        }
    }

    public double getActualValue() {
        return this.actualValue;
    }

    public void addListener(SliderListener listener) {
        this.listeners.add(listener);
    }

    private void trySetActualValue(double newActualValue) {
        if (newActualValue > this.maxValue || newActualValue < this.minValue) {
            return;
        }
        this.f_93577_ = (newActualValue - this.minValue) / (this.maxValue - this.minValue);
        this.applyValueInner(true);
    }

    private double calculateShift(int modifiers) {
        boolean isShiftDown = (modifiers & 1) != 0;
        boolean isAltDown = (modifiers & 4) != 0;
        boolean isCtrlDown = (modifiers & 2) != 0;
        double shift = 0.0;
        if (isShiftDown) {
            shift += 5.0;
        }
        if (isAltDown) {
            shift += 10.0;
        }
        if (isCtrlDown) {
            shift += 20.0;
        }
        if (shift == 0.0) {
            shift = 1.0;
        }
        return shift *= this.stepSize;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.trySetActualValue(this.actualValue - this.calculateShift(modifiers));
            return true;
        }
        if (keyCode == 262) {
            this.trySetActualValue(this.actualValue + this.calculateShift(modifiers));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double moveFactor = 10.0 * (SliderWidget.isKeyPressed(340) ? 0.5 : 1.0);
        this.trySetActualValue(this.actualValue + delta * this.stepSize * moveFactor);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static boolean isKeyPressed(int key) {
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key) == 1;
    }

    @FunctionalInterface
    public static interface SliderListener {
        public void accept(double var1, double var3);
    }
}

