/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.auxiliaryScreen;

import com.lowdragmc.shimmer.client.auxiliaryScreen.KeyType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SuggestionEditBoxWidget
extends EditBox {
    private final int showNumbers = 10;
    public List<String> suggestions;
    private Set<ResourceLocation> allSuggestion;
    private static Map<KeyType, Set<ResourceLocation>> cache;
    String lastContent;
    String candidate;
    String lastCandidate;
    boolean isComplete = false;
    List<BiConsumer<KeyType, ResourceLocation>> completeListeners = new ArrayList<BiConsumer<KeyType, ResourceLocation>>();
    List<BiConsumer<KeyType, ResourceLocation>> candidateListeners = new ArrayList<BiConsumer<KeyType, ResourceLocation>>();
    KeyType type = KeyType.DEFAULT;

    public SuggestionEditBoxWidget(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.tryInitCache();
        this.allSuggestion = cache.get((Object)KeyType.DEFAULT);
        this.m_94199_(50);
    }

    public void addCompleteListener(BiConsumer<KeyType, ResourceLocation> consumer) {
        this.completeListeners.add(consumer);
    }

    public void addCandidateListener(BiConsumer<KeyType, ResourceLocation> consumer) {
        this.candidateListeners.add(consumer);
    }

    public void m_94120_() {
        ResourceLocation resourceLocation;
        super.m_94120_();
        boolean last = this.isComplete;
        if (ResourceLocation.m_135830_((String)this.m_94155_())) {
            resourceLocation = new ResourceLocation(this.m_94155_());
            this.isComplete = this.allSuggestion.contains(resourceLocation);
            if (!last && this.isComplete) {
                this.completeListeners.forEach(item -> item.accept(this.type, resourceLocation));
            }
        } else {
            this.isComplete = false;
        }
        if (!Objects.equals(this.candidate, this.lastCandidate)) {
            this.lastCandidate = this.candidate;
            if (this.lastCandidate != null && ResourceLocation.m_135830_((String)this.lastCandidate) && this.allSuggestion.contains(resourceLocation = new ResourceLocation(this.lastCandidate))) {
                this.candidateListeners.forEach(item -> item.accept(this.type, resourceLocation));
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.suggestions != null && this.suggestions.contains(this.m_94155_())) {
            return;
        }
        if (this.m_93696_() && !this.isComplete) {
            String currentContent = this.m_94155_();
            if (!Objects.equals(currentContent, this.lastContent)) {
                this.lastContent = currentContent;
                if (!currentContent.contains(":")) {
                    this.suggestions = ((Stream)this.allSuggestion.stream().parallel()).map(ResourceLocation::m_135827_).collect(Collectors.toSet()).stream().toList();
                } else {
                    this.lastContent = currentContent;
                    this.suggestions = ((Stream)this.allSuggestion.stream().parallel()).map(ResourceLocation::toString).filter(res -> res.startsWith(currentContent)).toList();
                }
            }
            if (this.suggestions.isEmpty()) {
                return;
            }
            int begin = this.suggestions.contains(this.lastCandidate) ? Math.max(0, this.suggestions.indexOf(this.lastCandidate) - 3) : 0;
            int max = Math.min(begin + 10, this.suggestions.size());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int gap = 9 + 8;
            this.fill(poseStack, this.f_93619_, gap * (max - begin + 1), 0x7F000000);
            if (this.candidate == null || !this.suggestions.contains(this.lastContent) && !this.suggestions.contains(this.candidate)) {
                this.candidate = this.suggestions.get(0);
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int currentHeight = 0;
            for (int i = begin; i < max; ++i) {
                String str = this.suggestions.get(i);
                int color = Objects.equals(str, this.candidate) ? -3223705 : -1;
                SuggestionEditBoxWidget.m_93236_((PoseStack)poseStack, (Font)font, (String)font.m_92834_(str, 200), (int)(this.f_93620_ + 5), (int)(this.f_93621_ + this.f_93619_ + currentHeight), (int)color);
                currentHeight += gap;
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 265: {
                this.candidate = this.suggestions.get(Math.max(0, this.suggestions.indexOf(this.candidate) - 1));
                break;
            }
            case 264: {
                this.candidate = this.suggestions.get(Math.min(this.suggestions.indexOf(this.candidate) + 1, this.suggestions.size() - 1));
                break;
            }
            case 258: {
                this.m_94144_((String)(this.m_94155_().isEmpty() || !this.m_94155_().contains(":") ? this.candidate + ":" : this.candidate));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void fill(PoseStack poseStack, int minY, int height, int color) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)minY, (int)(this.f_93620_ + this.f_93618_), (int)(minY + height), (int)color);
    }

    public void onModeChange(KeyType type) {
        this.m_94144_("");
        this.allSuggestion = cache.get((Object)type);
        this.type = type;
    }

    private void tryInitCache() {
        if (cache == null) {
            Set blocks = Registry.f_122824_.m_6566_();
            cache = Map.of(KeyType.LIGHT_ITEM, Set.copyOf(Registry.f_122827_.m_6566_()), KeyType.BLOOM_PARTICLE, Set.copyOf(Registry.f_122829_.m_6566_()), KeyType.BLOOM_FLUID, Set.copyOf(Registry.f_122822_.m_6566_()), KeyType.COLORED_BLOCK, Set.copyOf(blocks), KeyType.BLOOM_BLOCK, Set.copyOf(blocks));
        }
    }
}

