/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.light;

import com.lowdragmc.shimmer.client.light.LightManager;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class ColorPointLight {
    public static final int STRUCT_SIZE = 8;
    public float r;
    public float g;
    public float b;
    public float a;
    public float x;
    public float y;
    public float z;
    public float radius;
    LightManager lightManager;
    int offset;
    public boolean enable = true;
    final boolean uv;

    protected ColorPointLight(Vec3 pos, Template template, boolean uv) {
        this.a = template.a;
        this.r = template.r;
        this.g = template.g;
        this.b = template.b;
        this.radius = template.radius;
        this.x = (float)(pos.m_7096_() + 0.5);
        this.y = (float)(pos.m_7098_() + 0.5);
        this.z = (float)(pos.m_7094_() + 0.5);
        this.uv = uv;
    }

    protected ColorPointLight(BlockPos pos, Template template, boolean uv) {
        this.a = template.a;
        this.r = template.r;
        this.g = template.g;
        this.b = template.b;
        this.radius = template.radius;
        this.x = (float)pos.m_123341_() + 0.5f;
        this.y = (float)pos.m_123342_() + 0.5f;
        this.z = (float)pos.m_123343_() + 0.5f;
        this.uv = uv;
    }

    protected ColorPointLight(LightManager lightManager, Vector3f pos, int color, float radius, int offset, boolean uv) {
        this.x = pos.m_122239_();
        this.y = pos.m_122260_();
        this.z = pos.m_122269_();
        this.setColor(color);
        this.lightManager = lightManager;
        this.radius = radius;
        this.offset = offset;
        this.uv = uv;
    }

    public void setColor(int color) {
        this.a = (float)(color >> 24 & 0xFF) / 255.0f;
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
    }

    public void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRemoved() {
        return this.lightManager == null;
    }

    public void remove() {
        if (this.lightManager != null) {
            this.lightManager.removeLight(this);
            this.lightManager = null;
        }
    }

    public void update() {
        if (this.lightManager != null && this.offset >= 0 && this.uv) {
            Minecraft.m_91087_().execute(() -> this.lightManager.lightUBO.bufferSubData((long)this.offset, this.getData()));
        }
    }

    protected float[] getData() {
        return new float[]{this.r, this.g, this.b, this.a, this.x, this.y, this.z, this.radius};
    }

    public void uploadBuffer(FloatBuffer buffer) {
        buffer.put(this.getData());
    }

    public static class Template {
        public float r;
        public float g;
        public float b;
        public float a;
        public float radius;

        public Template(float radius, int color) {
            this.setColor(color);
            this.radius = radius;
        }

        public Template(float radius, float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.radius = radius;
        }

        public void setColor(int color) {
            this.a = (float)(color >> 24 & 0xFF) / 255.0f;
            this.r = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
        }
    }
}

