/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.light;

import com.google.common.collect.Maps;
import com.lowdragmc.shimmer.Configuration;
import com.lowdragmc.shimmer.FileUtility;
import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.Utils;
import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.shader.ShaderInjection;
import com.lowdragmc.shimmer.client.shader.ShaderUBO;
import com.lowdragmc.shimmer.config.BlockLight;
import com.lowdragmc.shimmer.config.ItemLight;
import com.lowdragmc.shimmer.config.ShimmerConfig;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.BufferUtils;

public enum LightManager {
    INSTANCE;

    private static final int MAXIMUM_LIGHT_SUPPORT = 2048;
    private static final int MAXIMUM_PLAYER_LIGHT_SUPPORT = 20;
    private final List<ColorPointLight> UV_LIGHT = new ArrayList<ColorPointLight>(2048);
    private final List<ColorPointLight> NO_UV_LIGHT = new ArrayList<ColorPointLight>(2048);
    private final Map<UUID, ColorPointLight> NO_UV_LIGHT_PLAYER = new HashMap<UUID, ColorPointLight>(20);
    private final FloatBuffer BUFFER = BufferUtils.createFloatBuffer((int)16384);
    ShaderUBO lightUBO;
    ShaderUBO envUBO;
    private static String lightShader;
    private int NO_UV_LIGHT_COUNT = 0;
    private final Map<Block, BiFunction<BlockState, BlockPos, ColorPointLight.Template>> BLOCK_MAP = Maps.newHashMap();
    private final Map<Fluid, ColorPointLight.Template> FLUID_MAP = Maps.newHashMap();
    private final Map<Item, Function<ItemStack, ColorPointLight.Template>> ITEM_MAP = new HashMap<Item, Function<ItemStack, ColorPointLight.Template>>();
    private final Map<ResourceLocation, Function<ItemStack, ColorPointLight.Template>> TAG_MAP = new HashMap<ResourceLocation, Function<ItemStack, ColorPointLight.Template>>();

    private static String getShimmerImport() {
        if (Services.PLATFORM.isAdditiveBlend()) {
            return "\n#define ADDITIVE\n#moj_import <shimmer.glsl>\n\n";
        }
        return "\n#moj_import <shimmer.glsl>\n\n";
    }

    private static String ChunkInjection(String s) {
        s = s.replace("void main()", LightManager.getShimmerImport() + "void main()");
        return new StringBuffer(s).insert(s.lastIndexOf(125), Services.PLATFORM.useLightMap() ? "vertexColor = color_light_uv(pos, vertexColor,UV2);\n" : "vertexColor = color_light(pos, vertexColor);\n").toString();
    }

    private static String PositionInjection(String s) {
        s = s.replace("void main()", LightManager.getShimmerImport() + "void main()");
        return new StringBuffer(s).insert(s.lastIndexOf(125), Services.PLATFORM.useLightMap() ? "vertexColor = color_light_uv(Position, vertexColor,UV2);\n" : "vertexColor = color_light(Position, vertexColor);\n").toString();
    }

    private static String EntityInjectionLightMapColor(String s) {
        s = s.replace("void main()", LightManager.getShimmerImport() + "void main()");
        return new StringBuffer(s).insert(s.lastIndexOf(125), "lightMapColor = color_light(IViewRotMat * Position, lightMapColor);\n").toString();
    }

    private static String EntityInjectionVertexColor(String s) {
        s = s.replace("void main()", LightManager.getShimmerImport() + "void main()");
        return new StringBuffer(s).insert(s.lastIndexOf(125), "vertexColor = color_light(IViewRotMat * Position, vertexColor);\n").toString();
    }

    private static String getLightShader() {
        if (lightShader == null) {
            try {
                lightShader = FileUtility.readInputStream(LightManager.class.getResourceAsStream("/assets/minecraft/shaders/include/shimmer.glsl"));
                lightShader = lightShader.replace("#version 150", "");
            }
            catch (IOException e) {
                ShimmerConstants.LOGGER.error("error while loading shimmer lighting shader");
                lightShader = "";
            }
        }
        if (Services.PLATFORM.isAdditiveBlend()) {
            return "\n#define ADDITIVE\n" + lightShader;
        }
        return lightShader;
    }

    public static String RbVVSHInjection(String s) {
        s = new StringBuffer(s).insert(s.lastIndexOf("out vec2 v_TexCoord;"), "out float isBloom;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf("void main()"), LightManager.getLightShader()).toString();
        s = new StringBuffer(s).insert(s.lastIndexOf(125), Services.PLATFORM.useLightMap() ? "    v_Color = color_light_uv(position, v_Color, _vert_tex_light_coord);\n" : "    v_Color = color_light(position, v_Color);\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf("}"), "isBloom = float(_vert_tex_light_coord.x);\n").toString();
        return s;
    }

    public void bindRbProgram(int programID) {
        this.lightUBO.bindToShader(programID, "Lights");
        this.envUBO.bindToShader(programID, "Env");
    }

    public static void onResourceManagerReload() {
        lightShader = null;
    }

    public static void injectShaders() {
        ShaderInjection.registerVSHInjection("particle", LightManager::PositionInjection);
        ShaderInjection.registerVSHInjection("rendertype_solid", LightManager::ChunkInjection);
        ShaderInjection.registerVSHInjection("rendertype_cutout", LightManager::ChunkInjection);
        ShaderInjection.registerVSHInjection("rendertype_cutout_mipped", LightManager::ChunkInjection);
        ShaderInjection.registerVSHInjection("rendertype_translucent", LightManager::ChunkInjection);
        ShaderInjection.registerVSHInjection("rendertype_armor_cutout_no_cull", LightManager::PositionInjection);
        ShaderInjection.registerVSHInjection("rendertype_entity_cutout", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_cutout_no_cull", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_cutout_no_cull_z_offset", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_decal", LightManager::EntityInjectionVertexColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_no_outline", LightManager::EntityInjectionVertexColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_smooth_cutout", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_solid", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_translucent", LightManager::EntityInjectionLightMapColor);
        ShaderInjection.registerVSHInjection("rendertype_entity_translucent_cull", LightManager::EntityInjectionVertexColor);
    }

    public static void clear() {
        for (ColorPointLight light : LightManager.INSTANCE.UV_LIGHT) {
            light.lightManager = null;
        }
        for (ColorPointLight light : LightManager.INSTANCE.NO_UV_LIGHT) {
            light.lightManager = null;
        }
        for (ColorPointLight light : LightManager.INSTANCE.NO_UV_LIGHT_PLAYER.values()) {
            light.lightManager = null;
        }
        LightManager.INSTANCE.UV_LIGHT.clear();
        LightManager.INSTANCE.NO_UV_LIGHT.clear();
        LightManager.INSTANCE.NO_UV_LIGHT_PLAYER.clear();
    }

    public int maxFixedLight() {
        return this.UV_LIGHT.size() + this.NO_UV_LIGHT.size() + this.NO_UV_LIGHT_PLAYER.size() + 20;
    }

    public int leftBlockLightCount() {
        return 2048 - this.maxFixedLight();
    }

    public FloatBuffer getBuffer() {
        return this.BUFFER;
    }

    public void renderLevelPre(int blockLightSize, float camX, float camY, float camZ) {
        this.updateNoUVLight();
        if (Services.PLATFORM.isColoredLightEnable()) {
            this.lightUBO.bufferSubData((long)this.getOffset(this.UV_LIGHT.size()), this.BUFFER);
            this.envUBO.bufferSubData(0L, new int[]{this.UV_LIGHT.size() + blockLightSize});
            this.envUBO.bufferSubData(4L, new int[]{this.NO_UV_LIGHT_COUNT});
            this.envUBO.bufferSubData(16L, new float[]{camX, camY, camZ});
        } else {
            this.envUBO.bufferSubData(0L, new int[4]);
        }
    }

    public void updateNoUVLight() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        this.NO_UV_LIGHT_COUNT = 0;
        Vec3 localPlayerPosition = localPlayer.m_20182_();
        List players = Minecraft.m_91087_().f_91073_.m_6907_();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        for (AbstractClientPlayer player : players) {
            ColorPointLight light;
            Vec3 position = player.m_20318_(partialTicks);
            if (player != localPlayer && !(position.m_82557_(localPlayerPosition) < 1024.0)) continue;
            UUID uuid = player.m_20148_();
            if (this.NO_UV_LIGHT_PLAYER.containsKey(uuid)) {
                light = this.NO_UV_LIGHT_PLAYER.get(uuid);
                if (!light.enable) continue;
                ++this.NO_UV_LIGHT_COUNT;
                light.uploadBuffer(this.BUFFER);
                if (this.NO_UV_LIGHT_COUNT <= 20) continue;
                break;
            }
            light = this.getItemLight(player.m_21205_(), position);
            if (light != null) {
                ++this.NO_UV_LIGHT_COUNT;
                light.uploadBuffer(this.BUFFER);
                if (this.NO_UV_LIGHT_COUNT <= 20) continue;
                break;
            }
            light = this.getItemLight(player.m_21206_(), position);
            if (light == null) continue;
            ++this.NO_UV_LIGHT_COUNT;
            light.uploadBuffer(this.BUFFER);
            if (this.NO_UV_LIGHT_COUNT <= 20) continue;
            break;
        }
        for (ColorPointLight light : this.NO_UV_LIGHT) {
            if (!light.enable) continue;
            light.uploadBuffer(this.BUFFER);
            ++this.NO_UV_LIGHT_COUNT;
        }
        this.BUFFER.flip();
    }

    public void renderLevelPost() {
        this.envUBO.bufferSubData(0L, new int[8]);
    }

    public void reloadShaders() {
        if (this.lightUBO == null) {
            int size = this.getOffset(2048);
            int uboOffset = Services.PLATFORM.getUniformBufferObjectOffset();
            this.lightUBO = new ShaderUBO();
            this.lightUBO.createBufferData(size, 35040);
            this.envUBO = new ShaderUBO();
            this.envUBO.createBufferData(32L, 35040);
            this.envUBO.bufferSubData(0L, new int[8]);
            this.lightUBO.blockBinding(uboOffset);
            this.envUBO.blockBinding(uboOffset + 1);
        }
        this.bindProgram("particle");
        this.bindProgram("rendertype_solid");
        this.bindProgram("rendertype_cutout");
        this.bindProgram("rendertype_cutout_mipped");
        this.bindProgram("rendertype_translucent");
        this.bindProgram("rendertype_armor_cutout_no_cull");
        this.bindProgram("rendertype_entity_cutout");
        this.bindProgram("rendertype_entity_cutout_no_cull");
        this.bindProgram("rendertype_entity_cutout_no_cull_z_offset");
        this.bindProgram("rendertype_entity_decal");
        this.bindProgram("rendertype_entity_no_outline");
        this.bindProgram("rendertype_entity_smooth_cutout");
        this.bindProgram("rendertype_entity_solid");
        this.bindProgram("rendertype_entity_translucent");
        this.bindProgram("rendertype_entity_translucent_cull");
    }

    private void bindProgram(String shaderName) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        ShaderInstance instance = gameRenderer.m_172734_(shaderName);
        if (instance != null) {
            this.lightUBO.bindToShader(instance.m_108943_(), "Lights");
            this.envUBO.bindToShader(instance.m_108943_(), "Env");
        }
    }

    @Nullable
    public ColorPointLight addLight(Vector3f pos, int color, float radius, boolean uv) {
        if (this.maxFixedLight() == 2048) {
            return null;
        }
        ColorPointLight light = new ColorPointLight(this, pos, color, radius, uv ? this.getOffset(this.UV_LIGHT.size()) : -1, uv);
        if (uv) {
            this.UV_LIGHT.add(light);
            this.lightUBO.bufferSubData((long)light.offset, light.getData());
        } else {
            this.NO_UV_LIGHT.add(light);
        }
        return light;
    }

    @Nullable
    public ColorPointLight addLight(Vector3f pos, int color, float radius) {
        return this.addLight(pos, color, radius, false);
    }

    private int getOffset(int index) {
        return index * 8 << 2;
    }

    void removeLight(ColorPointLight removed) {
        if (removed.uv) {
            int index = this.UV_LIGHT.indexOf(removed);
            if (index >= 0) {
                for (int i = index + 1; i < this.UV_LIGHT.size(); ++i) {
                    this.UV_LIGHT.get((int)i).offset = this.getOffset(i - 1);
                }
                this.UV_LIGHT.remove(index);
                if (index < this.UV_LIGHT.size()) {
                    Minecraft.m_91087_().execute(() -> {
                        this.BUFFER.clear();
                        for (int i = index; i < this.UV_LIGHT.size(); ++i) {
                            this.UV_LIGHT.get(i).uploadBuffer(this.BUFFER);
                        }
                        this.BUFFER.flip();
                        this.lightUBO.bufferSubData((long)this.getOffset(index), this.BUFFER);
                    });
                }
            }
        } else {
            this.NO_UV_LIGHT.remove(removed);
        }
    }

    public boolean isBlockHasLight(Block block, FluidState fluidState) {
        return this.BLOCK_MAP.containsKey(block) || !fluidState.m_76178_() && this.FLUID_MAP.containsKey(fluidState.m_76152_());
    }

    @Nullable
    public ColorPointLight getBlockStateLight(BlockAndTintGetter level, BlockPos blockpos, BlockState blockstate, FluidState fluidstate) {
        boolean solid = true;
        for (Direction side : Direction.values()) {
            BlockPos offset = blockpos.m_121945_(side);
            if (level.m_8055_(offset).m_60804_((BlockGetter)level, offset)) continue;
            solid = false;
            break;
        }
        if (solid) {
            return null;
        }
        ColorPointLight.Template template = this.BLOCK_MAP.getOrDefault(blockstate.m_60734_(), (s, p) -> null).apply(blockstate, blockpos);
        if (template == null && !fluidstate.m_76178_()) {
            template = this.FLUID_MAP.get(fluidstate.m_76152_());
        }
        return template == null ? null : new ColorPointLight(blockpos, template, false);
    }

    public void registerBlockLight(Block block, BiFunction<BlockState, BlockPos, ColorPointLight.Template> supplier) {
        if (block == Blocks.f_50016_) {
            return;
        }
        if (this.BLOCK_MAP.containsKey(block)) {
            BiFunction<BlockState, BlockPos, ColorPointLight.Template> exist = this.BLOCK_MAP.get(block);
            BiFunction<BlockState, BlockPos, ColorPointLight.Template> current = supplier;
            supplier = (blockState, pos) -> {
                ColorPointLight.Template template = (ColorPointLight.Template)current.apply((BlockState)blockState, (BlockPos)pos);
                if (template == null) {
                    template = (ColorPointLight.Template)exist.apply((BlockState)blockState, (BlockPos)pos);
                }
                return template;
            };
        }
        this.BLOCK_MAP.put(block, supplier);
    }

    public void registerBlockLight(Block block, int color, float radius) {
        ColorPointLight.Template template = new ColorPointLight.Template(radius, color);
        this.registerBlockLight(block, (state, pos) -> template);
    }

    public void registerFluidLight(Fluid fluid, int color, float radius) {
        ColorPointLight.Template template = new ColorPointLight.Template(radius, color);
        this.FLUID_MAP.put(fluid, template);
    }

    public void loadConfig() {
        this.ITEM_MAP.clear();
        this.TAG_MAP.clear();
        this.BLOCK_MAP.clear();
        this.FLUID_MAP.clear();
        for (ShimmerConfig config : Configuration.configs) {
            for (BlockLight blockLight : config.blockLights) {
                if (blockLight.blockName != null) {
                    Pair<ResourceLocation, Block> blockPair = blockLight.block();
                    if (blockPair == null || blockPair.left() == null || blockPair.right() == null) continue;
                    Block block = (Block)blockPair.right();
                    if (blockLight.hasState()) {
                        if (Utils.checkBlockProperties(config.configSource, blockLight.state, (ResourceLocation)blockPair.first())) continue;
                        List<BlockState> validStates = Utils.getAvailableStates(blockLight.state, block);
                        ColorPointLight.Template light = new ColorPointLight.Template(blockLight.radius, blockLight.color());
                        this.registerBlockLight(block, (blockState, pos) -> validStates.contains(blockState) ? light : null);
                        continue;
                    }
                    this.registerBlockLight(block, blockLight.color(), blockLight.radius);
                    continue;
                }
                Pair<ResourceLocation, Fluid> fluidPair = blockLight.fluid();
                if (fluidPair.right() == null) continue;
                this.registerFluidLight((Fluid)fluidPair.right(), blockLight.color(), blockLight.radius);
            }
            for (ItemLight itemLight : config.itemLights) {
                ColorPointLight.Template template = new ColorPointLight.Template(itemLight.radius, itemLight.color());
                if (itemLight.itemName != null) {
                    if (!ResourceLocation.m_135830_((String)itemLight.itemName)) {
                        ShimmerConstants.LOGGER.error("invalid item name " + itemLight.itemName + " form" + config.configSource);
                        continue;
                    }
                    ResourceLocation itemLocation = new ResourceLocation(itemLight.itemName);
                    if (!Registry.f_122827_.m_7804_(itemLocation)) {
                        ShimmerConstants.LOGGER.error("can't find item " + itemLocation + " from" + config.configSource);
                        continue;
                    }
                    Item item = (Item)Registry.f_122827_.m_7745_(itemLocation);
                    this.registerItemLight(item, itemStack -> template);
                    continue;
                }
                if (!ResourceLocation.m_135830_((String)itemLight.itemTag)) {
                    ShimmerConstants.LOGGER.error("invalid item tag name " + itemLight.itemTag + " form" + config.configSource);
                    continue;
                }
                this.registerTagLight(new ResourceLocation(itemLight.itemTag), itemStack -> template);
            }
        }
        Services.PLATFORM.postReloadEvent(new ShimmerReloadEvent(ShimmerReloadEvent.ReloadType.COLORED_LIGHT));
    }

    public int getLight(BlockGetter instance, BlockPos pPos) {
        BlockState blockState = instance.m_8055_(pPos);
        FluidState fluidState = blockState.m_60819_();
        int light = 0;
        if (this.isBlockHasLight(blockState.m_60734_(), fluidState)) {
            ColorPointLight.Template template = this.BLOCK_MAP.getOrDefault(blockState.m_60734_(), (s, p) -> null).apply(blockState, pPos);
            if (template == null && !fluidState.m_76178_()) {
                template = this.FLUID_MAP.get(fluidState.m_76152_());
            }
            if (template != null) {
                light = (int)template.radius;
            }
        }
        for (ColorPointLight colorPointLight : this.UV_LIGHT) {
            double r2;
            double dist = pPos.m_203198_((double)colorPointLight.x, (double)colorPointLight.y, (double)colorPointLight.z);
            if (!(dist < (r2 = (double)(colorPointLight.radius * colorPointLight.radius)))) continue;
            light = (int)Math.max(Math.sqrt(r2) - Math.sqrt(dist), (double)light);
        }
        return light;
    }

    @Nullable
    public ColorPointLight getItemLight(@Nonnull ItemStack itemStack, Vec3 pos) {
        ColorPointLight.Template template;
        Optional<TagKey> optional;
        Function<ItemStack, ColorPointLight.Template> function = this.ITEM_MAP.get(itemStack.m_41720_());
        if (function == null && (optional = itemStack.m_204131_().filter(tag -> this.TAG_MAP.containsKey(tag.f_203868_())).findAny()).isPresent()) {
            function = this.TAG_MAP.get(optional.get().f_203868_());
        }
        if (function != null && (template = function.apply(itemStack)) != null) {
            return new ColorPointLight(pos, template, false);
        }
        return null;
    }

    public void registerItemLight(Item item, Function<ItemStack, ColorPointLight.Template> function) {
        this.ITEM_MAP.put(item, function);
    }

    public void registerTagLight(ResourceLocation tag, Function<ItemStack, ColorPointLight.Template> function) {
        this.TAG_MAP.put(tag, function);
    }

    public ColorPointLight addPlayerItemLight(Vector3f pos, int color, float radius, UUID playerUUID) {
        if (this.maxFixedLight() == 2048) {
            return null;
        }
        ColorPointLight light = new ColorPointLight(this, pos, color, radius, -1, false);
        this.NO_UV_LIGHT_PLAYER.put(playerUUID, light);
        return light;
    }

    public boolean removePlayerLight(UUID playerUUID) {
        return this.NO_UV_LIGHT_PLAYER.remove(playerUUID) != null;
    }

    public boolean removePlayerLight(ColorPointLight removeLight) {
        Set<UUID> set = this.NO_UV_LIGHT_PLAYER.keySet();
        for (UUID uuid : set) {
            ColorPointLight light = this.NO_UV_LIGHT_PLAYER.get(uuid);
            if (light != removeLight) continue;
            this.NO_UV_LIGHT_PLAYER.remove(uuid, light);
            return true;
        }
        return false;
    }
}

