/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;

public record ShimmerMetadataSection(boolean bloom) {
    public static final String SECTION_NAME = "shimmer";
    private static final Map<ResourceLocation, ShimmerMetadataSection> METADATA_CACHE = new HashMap<ResourceLocation, ShimmerMetadataSection>();

    @Nullable
    public static ShimmerMetadataSection getMetadata(ResourceLocation res) {
        ShimmerMetadataSection ret;
        if (METADATA_CACHE.containsKey(res)) {
            return METADATA_CACHE.get(res);
        }
        try {
            ResourceMetadata metadata = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(res).orElseThrow()).m_215509_();
            ret = metadata.m_214059_((MetadataSectionSerializer)Serializer.INSTANCE).orElse(null);
        }
        catch (IOException | NoSuchElementException e) {
            ret = null;
        }
        METADATA_CACHE.put(res, ret);
        return ret;
    }

    public static boolean isBloom(TextureAtlasSprite sprite) {
        ShimmerMetadataSection ret = ShimmerMetadataSection.getMetadata(ShimmerMetadataSection.spriteToAbsolute(sprite.m_118413_()));
        return ret != null && ret.bloom;
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.m_135815_().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.m_135827_(), "textures/" + sprite.m_135815_());
        }
        if (!sprite.m_135815_().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.m_135827_(), sprite.m_135815_() + ".png");
        }
        return sprite;
    }

    public static void onResourceManagerReload() {
        METADATA_CACHE.clear();
    }

    public static class Serializer
    implements MetadataSectionSerializer<ShimmerMetadataSection> {
        static Serializer INSTANCE = new Serializer();

        @Nonnull
        public String m_7991_() {
            return ShimmerMetadataSection.SECTION_NAME;
        }

        @Nonnull
        public ShimmerMetadataSection fromJson(@Nonnull JsonObject json) {
            JsonElement element;
            JsonObject obj;
            boolean bloom = false;
            if (json.isJsonObject() && (obj = json.getAsJsonObject()).has("bloom") && (element = obj.get("bloom")).isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                bloom = element.getAsBoolean();
            }
            return new ShimmerMetadataSection(bloom);
        }
    }
}

