/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.postprocessing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lowdragmc.shimmer.Configuration;
import com.lowdragmc.shimmer.ShimmerConstants;
import com.lowdragmc.shimmer.Utils;
import com.lowdragmc.shimmer.client.postprocessing.IPostParticleType;
import com.lowdragmc.shimmer.client.postprocessing.PostMultiBufferSource;
import com.lowdragmc.shimmer.client.rendertarget.CopyDepthColorTarget;
import com.lowdragmc.shimmer.client.rendertarget.MRTTarget;
import com.lowdragmc.shimmer.client.rendertarget.ProxyTarget;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.lowdragmc.shimmer.client.shader.ShaderInjection;
import com.lowdragmc.shimmer.config.Bloom;
import com.lowdragmc.shimmer.config.ShimmerConfig;
import com.lowdragmc.shimmer.core.IMainTarget;
import com.lowdragmc.shimmer.core.IParticleEngine;
import com.lowdragmc.shimmer.core.mixins.BlendModeMixin;
import com.lowdragmc.shimmer.core.mixins.ShimmerMixinPlugin;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.platform.Services;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class PostProcessing
implements ResourceManagerReloadListener {
    public static final Set<RenderType> CHUNK_TYPES = Sets.newHashSet((Object[])new RenderType[]{RenderType.m_110451_(), RenderType.m_110457_(), RenderType.m_110463_()});
    private static final Map<String, PostProcessing> POST_PROCESSING_MAP = new HashMap<String, PostProcessing>();
    public static final PostProcessing BLOOM_UNREAL = new PostProcessing("bloom_unreal", new ResourceLocation("shimmer", "shaders/post/bloom_unreal.json"));
    public static final PostProcessing BLOOM_UNITY = new PostProcessing("bloom_unity", new ResourceLocation("shimmer", "shaders/post/bloom_unity.json"));
    public static final PostProcessing WARP = new PostProcessing("warp", new ResourceLocation("shimmer", "shaders/post/warp.json"));
    public static final PostProcessing VHS = new PostProcessing("vhs", new ResourceLocation("shimmer", "shaders/post/vhs.json"));
    public static final PostProcessing FLICKER = new PostProcessing("flicker", new ResourceLocation("shimmer", "shaders/post/flicker.json"));
    public static final PostProcessing HALFTONE = new PostProcessing("halftone", new ResourceLocation("shimmer", "shaders/post/halftone.json"));
    public static final PostProcessing DOT_SCREEN = new PostProcessing("dot_screen", new ResourceLocation("shimmer", "shaders/post/dot_screen.json"));
    public static AtomicBoolean enableBloomFilter = new AtomicBoolean(false);
    private static final Minecraft mc = Minecraft.m_91087_();
    public final String name;
    private CopyDepthColorTarget postTargetWithoutColor;
    private CopyDepthColorTarget postTargetWithColor;
    private PostChain postChain = null;
    private boolean loadFailed = false;
    private final ResourceLocation shader;
    private final List<Consumer<MultiBufferSource>> postEntityDrawFilter = Lists.newArrayList();
    private final List<Consumer<MultiBufferSource>> postEntityDrawForce = Lists.newArrayList();
    private final Map<ParticleRenderType, IPostParticleType> particleTypeMap = Maps.newHashMap();
    private boolean hasParticle;
    public static Set<BlockState> BLOOM_BLOCK = new HashSet<BlockState>();
    public static Set<Fluid> BLOOM_FLUID = new HashSet<Fluid>();
    public static Set<ResourceLocation> BLOOM_PARTICLE = new HashSet<ResourceLocation>();
    private static final ThreadLocal<Boolean> BLOCK_BLOOM = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Boolean> FLUID_BLOOM = ThreadLocal.withInitial(() -> false);

    private PostProcessing(String name, ResourceLocation shader) {
        this.shader = shader;
        this.name = name;
        POST_PROCESSING_MAP.put(name, this);
    }

    public static PostProcessing registerPost(String name, ResourceLocation shader) {
        return new PostProcessing(name, shader);
    }

    @Nullable
    public static PostProcessing getPost(String name) {
        return POST_PROCESSING_MAP.get(name);
    }

    public static Collection<PostProcessing> values() {
        return POST_PROCESSING_MAP.values();
    }

    public static PostProcessing getBlockBloom() {
        return BLOOM_UNREAL;
    }

    public static float getITime(float pPartialTicks) {
        if (PostProcessing.mc.f_91073_ == null || !((GameRules.BooleanValue)PostProcessing.mc.f_91073_.m_46469_().m_46170_(GameRules.f_46140_)).m_46223_()) {
            return (float)(System.currentTimeMillis() % 1200000L) / 1000.0f;
        }
        return ((float)(PostProcessing.mc.f_91073_.m_8044_() % 24000L) + pPartialTicks) / 20.0f;
    }

    public static void injectShaders() {
        ShaderInjection.registerVSHInjection("rendertype_solid", PostProcessing::BloomMRTVSHInjection);
        ShaderInjection.registerVSHInjection("rendertype_cutout", PostProcessing::BloomMRTVSHInjection);
        ShaderInjection.registerVSHInjection("rendertype_cutout_mipped", PostProcessing::BloomMRTVSHInjection);
        ShaderInjection.registerFSHInjection("rendertype_solid", PostProcessing::BloomMRTFSHInjection);
        ShaderInjection.registerFSHInjection("rendertype_cutout", PostProcessing::BloomMRTFSHInjection);
        ShaderInjection.registerFSHInjection("rendertype_cutout_mipped", PostProcessing::BloomMRTFSHInjection);
    }

    private static String BloomMRTVSHInjection(String s) {
        s = new StringBuffer(s).insert(s.lastIndexOf("void main()"), "out float isBloom;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf(125), "isBloom = float(UV2.x);\n").toString();
        return s;
    }

    private static String BloomMRTFSHInjection(String s) {
        s = s.replace("#version 150", "#version 330 core");
        s = new StringBuilder(s).insert(s.lastIndexOf("#moj_import <fog.glsl>"), "#moj_import <shimmer_fog.glsl>\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf("out vec4 fragColor"), "in float isBloom;\n").toString();
        s = s.replace("out vec4 fragColor", "layout (location = 0) out vec4 fragColor");
        s = new StringBuffer(s).insert(s.lastIndexOf("void main()"), "layout (location = 1) out vec4 bloomColor;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf(125), "    if (isBloom > 255.) {\n        bloomColor = fragColor * (1 - fogValue);\n    } else {\n        bloomColor = vec4(0.);\n    }\n").toString();
        s = new StringBuilder(s).insert(s.lastIndexOf("vec4 color"), "float fogValue;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf("FogColor") + "FogColor".length(), ",fogValue").toString();
        return s;
    }

    public static String RbBloomMRTFSHInjection(String s) {
        s = new StringBuffer(s).insert(s.lastIndexOf("in vec4 v_Color;"), "in float isBloom;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf("void main()"), "out vec4 bloomColor;\n").toString();
        s = new StringBuffer(s).insert(s.lastIndexOf(125), "    if (isBloom > 255.) {\n        bloomColor = fragColor * smoothstep(u_FogEnd,u_FogStart,v_FragDistance);\n    } else {\n        bloomColor = vec4(0.);\n    }\n").toString();
        return s;
    }

    public CopyDepthColorTarget getPostTarget(boolean hookColorAttachment) {
        if (hookColorAttachment) {
            if (this.postTargetWithColor == null) {
                this.postTargetWithColor = new CopyDepthColorTarget(mc.m_91385_(), hookColorAttachment);
                this.postTargetWithColor.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                this.postTargetWithColor.m_83954_(Minecraft.f_91002_);
            }
            return this.postTargetWithColor;
        }
        if (this.postTargetWithoutColor == null) {
            this.postTargetWithoutColor = new CopyDepthColorTarget(mc.m_91385_(), hookColorAttachment);
            this.postTargetWithoutColor.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            this.postTargetWithoutColor.m_83954_(Minecraft.f_91002_);
        }
        return this.postTargetWithoutColor;
    }

    private PostChain getPostChain() {
        if (this.loadFailed) {
            return null;
        }
        try {
            if (this.postChain == null) {
                this.postChain = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), this.shader);
                this.postChain.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
            }
        }
        catch (IOException e) {
            ShimmerConstants.LOGGER.error("load post: [{}] post chain: [{}] failed!", (Object)this.name, (Object)this.shader, (Object)e);
            this.loadFailed = true;
        }
        return this.postChain;
    }

    public void renderBlockPost() {
        PostChain postChain = this.getPostChain();
        if (postChain != null && Services.PLATFORM.useBlockBloom() && this.allowPost()) {
            enableBloomFilter.set(true);
            RenderTarget mainTarget = mc.m_91385_();
            this.renderPost(postChain, new MRTTarget((IMainTarget)mainTarget), mainTarget);
            ((IMainTarget)mainTarget).clearBloomTexture(Minecraft.f_91002_);
            mainTarget.m_83947_(false);
            enableBloomFilter.set(false);
        }
    }

    public void renderPost(@Nonnull PostChain postChain, RenderTarget post, RenderTarget output) {
        RenderTarget target = postChain.m_110036_("shimmer:input");
        if (target instanceof ProxyTarget) {
            ((ProxyTarget)target).setParent(post);
        }
        BlendMode lastBlendMode = BlendModeMixin.getLastApplied();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69465_();
        postChain.m_110023_(mc.m_91296_());
        RenderUtils.fastBlit(postChain.m_110036_("shimmer:output"), output);
        BlendModeMixin.setLastApplied(lastBlendMode);
    }

    public void renderEntityPost(ProfilerFiller profilerFiller) {
        if (!this.postEntityDrawFilter.isEmpty()) {
            RenderUtils.warpGLDebugLabel("post_filtered_" + this.name, () -> {
                BlendMode lastBlendMode = BlendModeMixin.getLastApplied();
                profilerFiller.m_6182_("ENTITY_" + this.name.toUpperCase());
                RenderTarget mainTarget = mc.m_91385_();
                CopyDepthColorTarget postTarget = this.getPostTarget(true);
                postTarget.m_83947_(false);
                PostMultiBufferSource bufferSource = PostMultiBufferSource.BUFFER_SOURCE;
                RenderUtils.warpGLDebugLabel("draw_post_entities", () -> {
                    postTarget.enabledAttachment();
                    for (Consumer<MultiBufferSource> sourceConsumer : this.postEntityDrawFilter) {
                        sourceConsumer.accept((MultiBufferSource)bufferSource);
                    }
                    bufferSource.m_109911_();
                    postTarget.disableAttachment();
                });
                this.postEntityDrawFilter.clear();
                PostChain postChain = this.getPostChain();
                if (postChain == null) {
                    return;
                }
                if (this.allowPost()) {
                    RenderUtils.warpGLDebugLabel("actual_post_process", () -> this.renderPost(postChain, postTarget, mainTarget));
                } else {
                    RenderUtils.warpGLDebugLabel("reject_post", () -> RenderUtils.fastBlit(postTarget, mainTarget));
                }
                postTarget.m_83954_(Minecraft.f_91002_);
                mainTarget.m_83947_(false);
                BlendModeMixin.setLastApplied(lastBlendMode);
                GlStateManager.m_84519_();
            });
        }
        if (!this.postEntityDrawForce.isEmpty()) {
            RenderUtils.warpGLDebugLabel("post_force_" + this.name, () -> {
                BlendMode lastBlendMode = BlendModeMixin.getLastApplied();
                profilerFiller.m_6182_("ENTITY_" + this.name.toUpperCase());
                RenderTarget mainTarget = mc.m_91385_();
                CopyDepthColorTarget postTarget = this.getPostTarget(false);
                postTarget.m_83947_(false);
                PostMultiBufferSource bufferSource = PostMultiBufferSource.BUFFER_SOURCE;
                RenderUtils.warpGLDebugLabel("draw_post_entities", () -> {
                    for (Consumer<MultiBufferSource> sourceConsumer : this.postEntityDrawForce) {
                        sourceConsumer.accept((MultiBufferSource)bufferSource);
                    }
                    bufferSource.m_109911_();
                });
                this.postEntityDrawForce.clear();
                PostChain postChain = this.getPostChain();
                if (postChain == null) {
                    return;
                }
                if (this.allowPost()) {
                    RenderUtils.warpGLDebugLabel("actual_post_process", () -> this.renderPost(postChain, postTarget, mainTarget));
                } else {
                    RenderUtils.warpGLDebugLabel("reject_post", () -> RenderUtils.fastBlit(postTarget, mainTarget));
                }
                postTarget.m_83954_(Minecraft.f_91002_);
                mainTarget.m_83947_(false);
                BlendModeMixin.setLastApplied(lastBlendMode);
                GlStateManager.m_84519_();
            });
        }
    }

    public boolean allowPost() {
        return this != BLOOM_UNREAL && this != BLOOM_UNITY || Services.PLATFORM.isBloomEnable();
    }

    public void renderParticlePost() {
        if (this.hasParticle) {
            this.hasParticle = false;
            RenderTarget mainTarget = mc.m_91385_();
            CopyDepthColorTarget postTarget = this.getPostTarget(false);
            postTarget.m_83947_(false);
            PostChain postChain = this.getPostChain();
            if (postChain == null) {
                return;
            }
            if (this.allowPost()) {
                this.renderPost(postChain, postTarget, mainTarget);
            } else {
                RenderUtils.fastBlit(postTarget, mainTarget);
            }
            postTarget.m_83954_(Minecraft.f_91002_);
            mainTarget.m_83947_(false);
        }
    }

    public void postEntity(Consumer<MultiBufferSource> sourceConsumer) {
        if (ShimmerMixinPlugin.IS_OPT_LOAD) {
            sourceConsumer.accept((MultiBufferSource)PostMultiBufferSource.BUFFER_SOURCE);
            PostMultiBufferSource.BUFFER_SOURCE.m_109911_();
            return;
        }
        this.postEntityDrawFilter.add(sourceConsumer);
    }

    public void postEntityForce(Consumer<MultiBufferSource> sourceConsumer) {
        if (ShimmerMixinPlugin.IS_OPT_LOAD) {
            sourceConsumer.accept((MultiBufferSource)PostMultiBufferSource.BUFFER_SOURCE);
            PostMultiBufferSource.BUFFER_SOURCE.m_109911_();
            return;
        }
        this.postEntityDrawForce.add(sourceConsumer);
    }

    public void postParticle(ParticleOptions particleOptions, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        if (ShimmerMixinPlugin.IS_OPT_LOAD) {
            PostProcessing.mc.f_91061_.m_107370_(particleOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            return;
        }
        if (PostProcessing.mc.f_91061_ instanceof IParticleEngine) {
            ((IParticleEngine)PostProcessing.mc.f_91061_).createPostParticle(this, particleOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public void postParticle(ParticleOptions particleOptions, int viewDistanceSqr, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        if (ShimmerMixinPlugin.IS_OPT_LOAD) {
            PostProcessing.mc.f_91061_.m_107370_(particleOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            return;
        }
        if (PostProcessing.mc.f_91061_ instanceof IParticleEngine) {
            Camera camera = PostProcessing.mc.f_91063_.m_109153_();
            if (camera.m_90583_().m_82531_(pX, pY, pZ) > (double)viewDistanceSqr) {
                return;
            }
            ((IParticleEngine)PostProcessing.mc.f_91061_).createPostParticle(this, particleOptions, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public void postParticle(Particle particle) {
        if (ShimmerMixinPlugin.IS_OPT_LOAD) {
            PostProcessing.mc.f_91061_.m_107344_(particle);
            return;
        }
        if (PostProcessing.mc.f_91061_ instanceof IParticleEngine) {
            particle = Services.PLATFORM.createPostParticle(particle, this);
            PostProcessing.mc.f_91061_.m_107344_(particle);
        }
    }

    public ParticleRenderType getParticleType(ParticleRenderType renderType) {
        return this.particleTypeMap.computeIfAbsent(renderType, type -> new IPostParticleType(){
            final /* synthetic */ ParticleRenderType val$type;
            {
                this.val$type = particleRenderType;
            }

            @Override
            public ParticleRenderType getParent() {
                return this.val$type;
            }

            @Override
            public PostProcessing getPost() {
                return PostProcessing.this;
            }

            public String toString() {
                return "POST_WRAPPED_" + this.val$type.toString();
            }
        });
    }

    public static List<IPostParticleType> getBlockBloomPostParticleTypes() {
        return List.copyOf(PostProcessing.getBlockBloom().particleTypeMap.values());
    }

    public void m_6213_(@Nullable ResourceManager pResourceManager) {
        if (this.postChain != null) {
            this.postChain.close();
        }
        if (this.postTargetWithoutColor != null) {
            this.postTargetWithoutColor.m_83930_();
        }
        if (this.postTargetWithColor != null) {
            this.postTargetWithColor.m_83930_();
        }
        this.postTargetWithoutColor = null;
        this.postTargetWithColor = null;
        this.postChain = null;
        this.loadFailed = false;
    }

    public static void resize(int width, int height) {
        for (PostProcessing postProcessing : PostProcessing.values()) {
            if (postProcessing.postChain == null) continue;
            postProcessing.postChain.m_110025_(width, height);
        }
        for (PostProcessing postProcessing : PostProcessing.values()) {
            if (postProcessing.postTargetWithColor != null) {
                postProcessing.postTargetWithColor.resize(mc.m_91385_(), Minecraft.f_91002_);
            }
            if (postProcessing.postTargetWithoutColor == null) continue;
            postProcessing.postTargetWithoutColor.resize(mc.m_91385_(), Minecraft.f_91002_);
        }
    }

    public void hasParticle() {
        this.hasParticle = true;
    }

    public static void loadConfig() {
        BLOOM_BLOCK.clear();
        BLOOM_FLUID.clear();
        BLOOM_PARTICLE.clear();
        for (ShimmerConfig config : Configuration.configs) {
            for (Bloom bloom : config.blooms) {
                if (bloom.particleName != null) {
                    if (!ResourceLocation.m_135830_((String)bloom.particleName)) {
                        ShimmerConstants.LOGGER.error("invalid particle name " + bloom.particleName + " form" + config.configSource);
                        continue;
                    }
                    ResourceLocation particleLocation = new ResourceLocation(bloom.particleName);
                    BLOOM_PARTICLE.add(particleLocation);
                    continue;
                }
                if (bloom.fluidName != null) {
                    Pair<ResourceLocation, Fluid> fluid = bloom.fluid();
                    if (fluid == null || fluid.right() == null) continue;
                    BLOOM_FLUID.add((Fluid)fluid.right());
                    continue;
                }
                Pair<ResourceLocation, Block> blockPair = bloom.block();
                if (blockPair == null || blockPair.left() == null || blockPair.right() == null) continue;
                Block block = (Block)blockPair.right();
                if (bloom.hasState()) {
                    if (Utils.checkBlockProperties(config.configSource, bloom.state, (ResourceLocation)blockPair.left())) continue;
                    List<BlockState> availableStates = Utils.getAvailableStates(bloom.state, block);
                    BLOOM_BLOCK.addAll(availableStates);
                    continue;
                }
                BLOOM_BLOCK.addAll((Collection<BlockState>)block.m_49965_().m_61056_());
            }
        }
        Services.PLATFORM.postReloadEvent(new ShimmerReloadEvent(ShimmerReloadEvent.ReloadType.BLOOM));
    }

    public static boolean isBlockBloom() {
        return BLOCK_BLOOM.get();
    }

    public static boolean isFluidBloom() {
        return FLUID_BLOOM.get();
    }

    public static void setupBloom(BlockState blockState, FluidState fluidState) {
        FlowingFluid flowingFluid;
        if (BLOOM_BLOCK.contains(blockState)) {
            BLOCK_BLOOM.set(true);
        } else {
            BLOCK_BLOOM.set(false);
        }
        Fluid fluid = fluidState.m_76152_();
        if (BLOOM_FLUID.contains(fluid) || fluid instanceof FlowingFluid && BLOOM_FLUID.contains((flowingFluid = (FlowingFluid)fluid).m_5613_())) {
            FLUID_BLOOM.set(true);
        } else {
            FLUID_BLOOM.set(false);
        }
    }

    public static void forceBloomBlock(Runnable runnable) {
        BLOCK_BLOOM.set(true);
        runnable.run();
        BLOCK_BLOOM.set(false);
    }

    public static void forceBloomFluid(Runnable runnable) {
        FLUID_BLOOM.set(true);
        runnable.run();
        FLUID_BLOOM.set(false);
    }

    public static void cleanBloom() {
        BLOCK_BLOOM.set(false);
        FLUID_BLOOM.set(false);
    }
}

