/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.shimmer.client.shader;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;

@ParametersAreNonnullByDefault
public class ReloadShaderManager {
    private static Map<ResourceLocation, Resource> reloadResources = new HashMap<ResourceLocation, Resource>();
    public static boolean isReloading = false;
    private static boolean foreReloadAll = false;
    private static final ResourceProvider reloadShaderResource = res -> Optional.of(reloadResources.get(res));
    public static ResourceManager reloadResourceManager = new ResourceManager(){

        public Set<String> m_7187_() {
            return Set.of();
        }

        public List<Resource> m_213829_(ResourceLocation location) {
            return List.of(this.m_213713_(location).orElseThrow());
        }

        public Map<ResourceLocation, Resource> m_214159_(String path, Predicate<ResourceLocation> filter) {
            return Map.of();
        }

        public Map<ResourceLocation, List<Resource>> m_214160_(String path, Predicate<ResourceLocation> filter) {
            return Map.of();
        }

        public Optional<Resource> m_213713_(ResourceLocation location) {
            return Optional.of(reloadResources.get(location));
        }

        public Resource m_215593_(ResourceLocation resourceLocation) throws FileNotFoundException {
            try {
                return Objects.requireNonNull(reloadResources.get(resourceLocation));
            }
            catch (NullPointerException e) {
                throw new FileNotFoundException("resourceLocation:" + resourceLocation + " is not stored");
            }
        }

        public InputStream m_215595_(ResourceLocation resourceLocation) throws IOException {
            return reloadResources.get(resourceLocation).m_215507_();
        }

        public BufferedReader m_215597_(ResourceLocation resourceLocation) throws IOException {
            return reloadResources.get(resourceLocation).m_215508_();
        }

        public Stream<PackResources> m_7536_() {
            return null;
        }
    };

    private static void recordResource(ResourceLocation resourceLocation, Resource resource) {
        reloadResources.put(resourceLocation, resource);
    }

    public static void cleanResource() {
        ReloadShaderManager.message((Component)Component.m_237113_((String)"clear all resource for backup usage"));
        reloadResources.clear();
    }

    private static void recordCopyResource(ResourceLocation resourceLocation, Resource resource) {
        try (InputStream res = resource.m_215507_();){
            byte[] data = res.readAllBytes();
            Resource.IoSupplier ioSupplier = () -> new ByteArrayInputStream(data);
            Resource copyResource = new Resource(resource.m_215506_(), ioSupplier);
            ReloadShaderManager.recordResource(resourceLocation, copyResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadShader() {
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceManager resourceManager = minecraft.m_91098_();
        ReloadShaderManager.message((Component)Component.m_237113_((String)"start reloading shader"));
        long time = System.currentTimeMillis();
        Map<ResourceLocation, Resource> backupResource = reloadResources;
        reloadResources = new HashMap<ResourceLocation, Resource>();
        isReloading = true;
        foreReloadAll = false;
        try {
            minecraft.f_91063_.m_6213_(resourceManager);
            minecraft.f_91060_.m_6213_(resourceManager);
            ReloadShaderManager.message((Component)Component.m_237113_((String)"reload success"));
            ReloadShaderManager.message((Component)Component.m_237113_((String)MessageFormat.format("cache resource:{0}", reloadResources.size())));
            ReloadShaderManager.message((Component)Component.m_237113_((String)MessageFormat.format("total time cost:{0}s", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f))));
            backupResource.clear();
        }
        catch (Exception tryException) {
            foreReloadAll = true;
            reloadResources.clear();
            reloadResources = backupResource;
            ReloadShaderManager.message((Component)Component.m_237113_((String)"exception occur will reloading , trying to backup").m_130940_(ChatFormatting.RED));
            ReloadShaderManager.message((Component)Component.m_237113_((String)MessageFormat.format("error:{0}", tryException.getMessage())).m_130940_(ChatFormatting.RED));
            try {
                minecraft.f_91063_.m_6213_(resourceManager);
                minecraft.f_91060_.m_6213_(resourceManager);
                ReloadShaderManager.message((Component)Component.m_237113_((String)"load backup resource successful"));
            }
            catch (Exception backupException) {
                ReloadShaderManager.message((Component)Component.m_237113_((String)"exception occur while trying backup").m_130940_(ChatFormatting.RED));
                ReloadShaderManager.message((Component)Component.m_237113_((String)MessageFormat.format("error:{0}", backupException.getMessage())).m_130940_(ChatFormatting.RED));
                backupException.addSuppressed(tryException);
                throw backupException;
            }
        }
        finally {
            isReloading = false;
            foreReloadAll = false;
        }
    }

    private static void message(Component component) {
        Minecraft.m_91087_().f_91074_.m_213846_(component);
    }

    @Nonnull
    public static ShaderInstance backupNewShaderInstance(ResourceProvider resourceProvider, String shaderName, VertexFormat vertexFormat) throws IOException {
        if (foreReloadAll) {
            return new ShaderInstance(reloadShaderResource, shaderName, vertexFormat);
        }
        ShaderInstance shaderInstance = new ShaderInstance(resourceProvider, shaderName, vertexFormat);
        ResourceLocation shaderResourceLocation = new ResourceLocation(shaderName);
        ReloadShaderManager.recordProgramResource(resourceProvider, shaderResourceLocation.m_135827_(), shaderResourceLocation.m_135815_());
        return shaderInstance;
    }

    public static ShaderInstance backupNewShaderInstance(ResourceProvider resourceProvider, ResourceLocation shaderLocation, VertexFormat vertexFormat) throws IOException {
        return ReloadShaderManager.backupNewShaderInstance(resourceProvider, shaderLocation.toString(), vertexFormat);
    }

    @Nonnull
    private static void recordProgramResource(ResourceProvider resourceProvider, String nameSpace, String shaderName) throws IOException {
        ResourceLocation programResourceLocation = new ResourceLocation(nameSpace, "shaders/core/" + shaderName + ".json");
        Resource programResource = (Resource)resourceProvider.m_213713_(programResourceLocation).orElseThrow();
        ReloadShaderManager.recordCopyResource(programResourceLocation, programResource);
        JsonObject jsonObject = GsonHelper.m_13859_((Reader)new InputStreamReader(((Resource)resourceProvider.m_213713_(programResourceLocation).orElseThrow()).m_215507_(), StandardCharsets.UTF_8));
        ResourceLocation vertex = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"vertex"));
        ResourceLocation vertexResourceLocation = new ResourceLocation(vertex.m_135827_(), "shaders/core/" + vertex.m_135815_() + ".vsh");
        ReloadShaderManager.recordCopyResource(vertexResourceLocation, (Resource)resourceProvider.m_213713_(vertexResourceLocation).orElseThrow());
        ResourceLocation fragment = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fragment"));
        ResourceLocation fragmentResourceLocation = new ResourceLocation(fragment.m_135827_(), "shaders/core/" + fragment.m_135815_() + ".fsh");
        ReloadShaderManager.recordCopyResource(fragmentResourceLocation, (Resource)resourceProvider.m_213713_(fragmentResourceLocation).orElseThrow());
    }

    public static PostChain backupNewPostChain(TextureManager textureManager, ResourceManager resourceManager, RenderTarget renderTarget, ResourceLocation resourceLocation) throws IOException {
        if (foreReloadAll) {
            return new PostChain(textureManager, reloadResourceManager, renderTarget, resourceLocation);
        }
        PostChain postChain = new PostChain(textureManager, resourceManager, renderTarget, resourceLocation);
        ReloadShaderManager.recordPostChainResource(resourceManager, resourceLocation);
        return postChain;
    }

    private static void recordPostChainResource(ResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        Resource postChainResource = (Resource)resourceManager.m_213713_(resourceLocation).orElseThrow();
        ReloadShaderManager.recordCopyResource(resourceLocation, postChainResource);
    }

    public static EffectInstance backupNewEffectInstance(ResourceManager resourceProvider, String shaderName) throws IOException {
        if (foreReloadAll) {
            return new EffectInstance(reloadResourceManager, shaderName);
        }
        EffectInstance effectInstance = new EffectInstance(resourceProvider, shaderName);
        ReloadShaderManager.recordEffectInstanceResource(resourceProvider, shaderName);
        return effectInstance;
    }

    private static void recordEffectInstanceResource(ResourceManager resourceProvider, String shaderName) throws IOException {
        ResourceLocation resourceLocation = ReloadShaderManager.make(ResourceLocation.m_135820_((String)shaderName), rl -> new ResourceLocation(rl.m_135827_(), "shaders/program/" + rl.m_135815_() + ".json"));
        Resource effectResource = (Resource)resourceProvider.m_213713_(resourceLocation).orElseThrow();
        ReloadShaderManager.recordCopyResource(resourceLocation, effectResource);
        JsonObject effectJsonObject = GsonHelper.m_13859_((Reader)new InputStreamReader(((Resource)resourceProvider.m_213713_(resourceLocation).orElseThrow()).m_215507_(), StandardCharsets.UTF_8));
        String vertex = GsonHelper.m_13906_((JsonObject)effectJsonObject, (String)"vertex");
        ResourceLocation vertexResourceLocation = ReloadShaderManager.make(ResourceLocation.m_135820_((String)vertex), rl -> new ResourceLocation(rl.m_135827_(), "shaders/program/" + rl.m_135815_() + ".vsh"));
        ReloadShaderManager.recordCopyResource(vertexResourceLocation, (Resource)resourceProvider.m_213713_(vertexResourceLocation).orElseThrow());
        String fragment = GsonHelper.m_13906_((JsonObject)effectJsonObject, (String)"fragment");
        ResourceLocation fragmentResourceLocation = ReloadShaderManager.make(ResourceLocation.m_135820_((String)fragment), rl -> new ResourceLocation(rl.m_135827_(), "shaders/program/" + rl.m_135815_() + ".fsh"));
        ReloadShaderManager.recordCopyResource(fragmentResourceLocation, (Resource)resourceProvider.m_213713_(fragmentResourceLocation).orElseThrow());
    }

    private static <T, R> R make(T origin, Function<T, R> transformer) {
        return transformer.apply(origin);
    }
}

